/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperatorSerializer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;

public abstract class PositionedOperator
extends OperatorBase
implements INBTProvider {
    private DimPos pos;
    private EnumFacing side;

    protected PositionedOperator(String symbol, String operatorName, IValueType[] inputTypes, IValueType outputType, OperatorBase.IFunction function, IConfigRenderPattern renderPattern, DimPos pos, EnumFacing side) {
        super(symbol, operatorName, inputTypes, outputType, function, renderPattern);
        this.pos = pos;
        this.side = side;
    }

    @Override
    public IOperator materialize() {
        return this;
    }

    public void writeGeneratedFieldsToNBT(NBTTagCompound tag) {
        NBTClassType.writeNbt(DimPos.class, (String)"pos", (Object)this.pos, (NBTTagCompound)tag);
        NBTClassType.writeNbt(EnumFacing.class, (String)"side", (Object)this.side, (NBTTagCompound)tag);
    }

    public void readGeneratedFieldsFromNBT(NBTTagCompound tag) {
        this.pos = (DimPos)NBTClassType.readNbt(DimPos.class, (String)"pos", (NBTTagCompound)tag);
        this.side = (EnumFacing)NBTClassType.readNbt(EnumFacing.class, (String)"side", (NBTTagCompound)tag);
    }

    public DimPos getPos() {
        return this.pos;
    }

    public void setPos(DimPos pos) {
        this.pos = pos;
    }

    public EnumFacing getSide() {
        return this.side;
    }

    public void setSide(EnumFacing side) {
        this.side = side;
    }

    public static class Serializer
    implements IOperatorSerializer<PositionedOperator> {
        private final Class<? extends PositionedOperator> clazz;
        private final String uniqueName;

        public Serializer(Class<? extends PositionedOperator> clazz, String uniqueName) {
            this.clazz = clazz;
            this.uniqueName = uniqueName;
        }

        @Override
        public boolean canHandle(IOperator operator) {
            return this.clazz.isInstance(operator);
        }

        @Override
        public String getUniqueName() {
            return this.uniqueName;
        }

        @Override
        public String serialize(PositionedOperator operator) {
            NBTTagCompound tag = new NBTTagCompound();
            operator.writeGeneratedFieldsToNBT(tag);
            return tag.toString();
        }

        @Override
        public PositionedOperator deserialize(String value) throws EvaluationException {
            try {
                Constructor<? extends PositionedOperator> constructor = this.clazz.getConstructor(new Class[0]);
                PositionedOperator proxy = constructor.newInstance(new Object[0]);
                NBTTagCompound tag = JsonToNBT.func_180713_a((String)value);
                proxy.readGeneratedFieldsFromNBT(tag);
                return proxy;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | NBTException e) {
                e.printStackTrace();
                throw new EvaluationException(e.getMessage());
            }
        }
    }
}

