/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.model;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.BlockPartRotation;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.model.DelegatingDynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.client.model.IRenderState;
import org.lwjgl.util.vector.Vector3f;

public abstract class CableModelBase
extends DelegatingDynamicItemAndBlockModel {
    private static final FaceBakery FACE_BAKERY = new FaceBakery();
    private static final Cache<Triple<IRenderState, EnumFacing, BlockRenderLayer>, List<BakedQuad>> CACHE_QUADS = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private static final int RADIUS = 4;
    private static final int TEXTURE_SIZE = 16;
    private static final int LENGTH_CONNECTION = 6;
    private static final int LENGTH_CONNECTION_LIMITED = 1;
    private static final int INV_LENGTH_CONNECTION = 10;
    public static final float MIN = 0.375f;
    public static final float MAX = 0.625f;
    private static final PartRenderPosition CABLE_RENDERPOSITION = new PartRenderPosition(-1.0f, 0.375f, 0.25f, 0.25f);
    private final float[][][] quadVertexes = CableModelBase.makeQuadVertexes(0.375f, 0.625f, 1.0f);
    protected static final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> TRANSFORMS = ModelHelpers.modifyDefaultTransforms((Map)ImmutableMap.of((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new javax.vecmath.Vector3f(0.0f, 0.03125f, 0.0f), TRSRTransformation.quatFromXYZDegrees((javax.vecmath.Vector3f)new javax.vecmath.Vector3f(0.0f, 45.0f, 0.0f)), new javax.vecmath.Vector3f(0.4f, 0.4f, 0.4f), null)), (Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new javax.vecmath.Vector3f(0.0f, 0.03125f, 0.0f), TRSRTransformation.quatFromXYZDegrees((javax.vecmath.Vector3f)new javax.vecmath.Vector3f(0.0f, 225.0f, 0.0f)), new javax.vecmath.Vector3f(0.4f, 0.4f, 0.4f), null))));

    public CableModelBase(IBlockState blockState, EnumFacing facing, long rand) {
        super(blockState, facing, rand);
    }

    public CableModelBase(ItemStack itemStack, World world, EntityLivingBase entity) {
        super(itemStack, world, entity);
    }

    public CableModelBase() {
    }

    protected static float[][][] makeQuadVertexes(float min, float max, float length) {
        return new float[][][]{new float[][]{{min, length, min}, {max, length, min}, {max, max, min}, {min, max, min}}, new float[][]{{min, max, min}, {min, max, max}, {min, length, max}, {min, length, min}}, new float[][]{{min, max, max}, {max, max, max}, {max, length, max}, {min, length, max}}, new float[][]{{max, length, min}, {max, length, max}, {max, max, max}, {max, max, min}}};
    }

    private EnumFacing getSideFromVecs(Vec3d a, Vec3d b, Vec3d c) {
        int dir;
        int n = a.field_72448_b == b.field_72448_b && b.field_72448_b == c.field_72448_b ? 0 : (dir = a.field_72450_a == b.field_72450_a && b.field_72450_a == c.field_72450_a ? 2 : 4);
        if (dir == 0) {
            dir += c.field_72448_b >= 0.5 ? 1 : 0;
        } else if (dir == 2) {
            dir += c.field_72450_a >= 0.5 ? 1 : 0;
        } else if (dir == 4) {
            dir += c.field_72449_c >= 0.5 ? 1 : 0;
        }
        return EnumFacing.func_82600_a((int)dir);
    }

    public List<BakedQuad> getFacadeQuads(IBlockState blockState, EnumFacing side, PartRenderPosition partRenderPosition) {
        Random rand = new Random();
        LinkedList ret = Lists.newLinkedList();
        IBakedModel model = RenderHelpers.getBakedModel((IBlockState)blockState);
        BakedQuad originalQuad = (BakedQuad)model.func_188616_a(blockState, side, rand.nextLong()).get(0);
        if (partRenderPosition == PartRenderPosition.NONE) {
            this.addFacadeQuad(ret, originalQuad, 0.0f, 0.0f, 1.0f, 1.0f, side);
        } else {
            float w = partRenderPosition.getWidthFactorSide();
            float h = partRenderPosition.getHeightFactorSide();
            float u0 = 0.0f;
            float v0 = 0.0f;
            float u1 = (1.0f - w) / 2.0f;
            float v1 = (1.0f - h) / 2.0f;
            float u2 = u1 + w;
            float v2 = v1 + h;
            float u3 = 1.0f;
            float v3 = 1.0f;
            this.addFacadeQuad(ret, originalQuad, u0, v0, u1, v1, side);
            this.addFacadeQuad(ret, originalQuad, u1, v0, u2, v1, side);
            this.addFacadeQuad(ret, originalQuad, u2, v0, u3, v1, side);
            this.addFacadeQuad(ret, originalQuad, u0, v1, u1, v2, side);
            this.addFacadeQuad(ret, originalQuad, u2, v1, u3, v2, side);
            this.addFacadeQuad(ret, originalQuad, u0, v2, u1, v3, side);
            this.addFacadeQuad(ret, originalQuad, u1, v2, u2, v3, side);
            this.addFacadeQuad(ret, originalQuad, u2, v2, u3, v3, side);
        }
        return ret;
    }

    private void addFacadeQuad(List<BakedQuad> quads, BakedQuad originalQuad, float u0, float v0, float u1, float v1, EnumFacing side) {
        Vector3f from = new Vector3f(u0 * 16.0f, v0 * 16.0f, 0.0f);
        Vector3f to = new Vector3f(u1 * 16.0f, v1 * 16.0f, 0.0f);
        TextureAtlasSprite texture = originalQuad.func_187508_a();
        float[] uvArray = new float[]{16.0f - u1 * 16.0f, 16.0f - v1 * 16.0f, 16.0f - u0 * 16.0f, 16.0f - v0 * 16.0f};
        int ROTATION_NONE = 0;
        BlockFaceUV blockFaceUV = new BlockFaceUV(uvArray, ROTATION_NONE);
        EnumFacing NO_FACE_CULLING = null;
        int TINT_INDEX_NONE = -1;
        String DUMMY_TEXTURE_NAME = "";
        BlockPartFace blockPartFace = new BlockPartFace(NO_FACE_CULLING, TINT_INDEX_NONE, DUMMY_TEXTURE_NAME, blockFaceUV);
        TRSRTransformation transformation = TRSRTransformation.from((EnumFacing)side);
        BlockPartRotation DEFAULT_ROTATION = null;
        boolean UV_LOCKED = true;
        boolean APPLY_SHADING = true;
        quads.add(FACE_BAKERY.makeBakedQuad(from, to, blockPartFace, texture, EnumFacing.NORTH, (ITransformation)transformation, DEFAULT_ROTATION, UV_LOCKED, APPLY_SHADING));
    }

    protected abstract boolean isRealCable();

    protected abstract Optional<IBlockState> getFacade();

    protected abstract boolean isConnected(EnumFacing var1);

    protected abstract boolean hasPart(EnumFacing var1);

    protected abstract PartRenderPosition getPartRenderPosition(EnumFacing var1);

    protected abstract boolean shouldRenderParts();

    protected abstract IBakedModel getPartModel(EnumFacing var1);

    protected abstract IRenderState getRenderState();

    public List<BakedQuad> getGeneralQuads() {
        IRenderState renderState;
        Triple cacheKey = null;
        List cachedQuads = null;
        if (GeneralConfig.cacheCableModels && (renderState = this.getRenderState()) != null) {
            cacheKey = Triple.of((Object)renderState, (Object)this.facing, (Object)MinecraftForgeClient.getRenderLayer());
            cachedQuads = (List)CACHE_QUADS.getIfPresent((Object)cacheKey);
        }
        if (cachedQuads == null) {
            boolean isConnected;
            LinkedList ret = Lists.newLinkedList();
            TextureAtlasSprite texture = this.func_177554_e();
            Optional<IBlockState> blockStateHolder = this.getFacade();
            boolean renderCable = this.isItemStack() || this.isRealCable() && MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.SOLID && !blockStateHolder.isPresent();
            for (EnumFacing side : EnumFacing.values()) {
                boolean hasPart;
                isConnected = this.isItemStack() ? side == EnumFacing.EAST || side == EnumFacing.WEST : this.isConnected(side);
                boolean bl = hasPart = !this.isItemStack() && this.hasPart(side);
                if (hasPart && this.shouldRenderParts()) {
                    try {
                        ret.addAll(this.getPartModel(side).func_188616_a(this.blockState, this.facing, this.rand));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!renderCable) continue;
                if (isConnected || hasPart) {
                    int i = 0;
                    float[][][] quadVertexes = this.quadVertexes;
                    if (hasPart) {
                        PartRenderPosition partRenderPosition = this.getPartRenderPosition(side);
                        float depthFactor = partRenderPosition == PartRenderPosition.NONE ? 0.0f : partRenderPosition.getDepthFactor();
                        quadVertexes = CableModelBase.makeQuadVertexes(0.375f, 0.625f, 1.0f - depthFactor);
                    }
                    for (float[][] v : quadVertexes) {
                        Vec3d v1 = CableModelBase.rotate((Vec3d)new Vec3d((double)v[0][0] - 0.5, (double)v[0][1] - 0.5, (double)v[0][2] - 0.5), (EnumFacing)side).func_72441_c(0.5, 0.5, 0.5);
                        Vec3d v2 = CableModelBase.rotate((Vec3d)new Vec3d((double)v[1][0] - 0.5, (double)v[1][1] - 0.5, (double)v[1][2] - 0.5), (EnumFacing)side).func_72441_c(0.5, 0.5, 0.5);
                        Vec3d v3 = CableModelBase.rotate((Vec3d)new Vec3d((double)v[2][0] - 0.5, (double)v[2][1] - 0.5, (double)v[2][2] - 0.5), (EnumFacing)side).func_72441_c(0.5, 0.5, 0.5);
                        Vec3d v4 = CableModelBase.rotate((Vec3d)new Vec3d((double)v[3][0] - 0.5, (double)v[3][1] - 0.5, (double)v[3][2] - 0.5), (EnumFacing)side).func_72441_c(0.5, 0.5, 0.5);
                        EnumFacing realSide = this.getSideFromVecs(v1, v2, v3);
                        boolean invert = i == 2 || i == 1;
                        int length = hasPart ? 1 : 6;
                        int[] data = Ints.concat((int[][])new int[][]{CableModelBase.vertexToInts((float)((float)v1.field_72450_a), (float)((float)v1.field_72448_b), (float)((float)v1.field_72449_c), (int)-1, (TextureAtlasSprite)texture, (float)6.0f, (float)(invert ? (float)length : 0.0f)), CableModelBase.vertexToInts((float)((float)v2.field_72450_a), (float)((float)v2.field_72448_b), (float)((float)v2.field_72449_c), (int)-1, (TextureAtlasSprite)texture, (float)10.0f, (float)(invert ? (float)length : 0.0f)), CableModelBase.vertexToInts((float)((float)v3.field_72450_a), (float)((float)v3.field_72448_b), (float)((float)v3.field_72449_c), (int)-1, (TextureAtlasSprite)texture, (float)10.0f, (float)(invert ? 0.0f : (float)length)), CableModelBase.vertexToInts((float)((float)v4.field_72450_a), (float)((float)v4.field_72448_b), (float)((float)v4.field_72449_c), (int)-1, (TextureAtlasSprite)texture, (float)6.0f, (float)(invert ? 0.0f : (float)length))});
                        ++i;
                        ForgeHooksClient.fillNormal((int[])data, (EnumFacing)realSide);
                        ret.add(new BakedQuad(data, -1, realSide, texture, true, DefaultVertexFormats.field_176599_b));
                    }
                    continue;
                }
                CableModelBase.addBakedQuad((List)ret, (float)0.375f, (float)0.625f, (float)0.375f, (float)0.625f, (float)0.625f, (TextureAtlasSprite)texture, (EnumFacing)side);
            }
            if (blockStateHolder.isPresent() && this.shouldRenderParts()) {
                for (EnumFacing side : EnumFacing.values()) {
                    boolean hasPart;
                    isConnected = this.isItemStack() ? side == EnumFacing.EAST || side == EnumFacing.WEST : this.isConnected(side);
                    PartRenderPosition partRenderPosition = PartRenderPosition.NONE;
                    boolean bl = hasPart = !this.isItemStack() && this.hasPart(side);
                    if (hasPart) {
                        partRenderPosition = this.getPartRenderPosition(side);
                    } else if (isConnected) {
                        partRenderPosition = CABLE_RENDERPOSITION;
                    }
                    ret.addAll(this.getFacadeQuads((IBlockState)blockStateHolder.get(), side, partRenderPosition));
                }
            }
            if (this.isItemStack()) {
                CableModelBase.addBakedQuad((List)ret, (float)0.375f, (float)0.625f, (float)0.375f, (float)0.625f, (float)1.0f, (TextureAtlasSprite)texture, (EnumFacing)EnumFacing.EAST);
                CableModelBase.addBakedQuad((List)ret, (float)0.375f, (float)0.625f, (float)0.375f, (float)0.625f, (float)1.0f, (TextureAtlasSprite)texture, (EnumFacing)EnumFacing.WEST);
            }
            cachedQuads = ret;
            if (cacheKey != null) {
                CACHE_QUADS.put((Object)cacheKey, (Object)cachedQuads);
            }
        }
        return cachedQuads;
    }

    public TextureAtlasSprite func_177554_e() {
        return BlockCable.getInstance().texture;
    }

    public IExtendedBlockState getState() {
        return (IExtendedBlockState)this.blockState;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation tr = (TRSRTransformation)ModelHelpers.DEFAULT_PERSPECTIVE_TRANSFORMS.get((Object)cameraTransformType);
        Matrix4f mat = null;
        if (tr != null && !tr.equals((Object)TRSRTransformation.identity())) {
            mat = TRSRTransformation.blockCornerToCenter((TRSRTransformation)tr).getMatrix();
        }
        return Pair.of((Object)((Object)this), mat);
    }
}

