/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.capability.facadeable;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.integrateddynamics.api.block.IFacadeable;
import org.cyclops.integrateddynamics.core.tileentity.TileMultipartTicking;

public class FacadeableTileMultipartTicking
implements IFacadeable {
    private final TileMultipartTicking tile;

    public FacadeableTileMultipartTicking(TileMultipartTicking tile) {
        this.tile = tile;
    }

    @Override
    public boolean hasFacade() {
        return this.tile.getFacadeBlockName() != null && !this.tile.getFacadeBlockName().isEmpty();
    }

    @Override
    public IBlockState getFacade() {
        if (!this.hasFacade()) {
            return null;
        }
        return BlockHelpers.deserializeBlockState((Pair)Pair.of((Object)this.tile.getFacadeBlockName(), (Object)this.tile.getFacadeMeta()));
    }

    @Override
    public void setFacade(@Nullable IBlockState blockState) {
        if (blockState == null) {
            this.tile.setFacadeMeta(0);
            this.tile.setFacadeBlockName(null);
        } else {
            Pair serializedBlockState = BlockHelpers.serializeBlockState((IBlockState)blockState);
            this.tile.setFacadeMeta((Integer)serializedBlockState.getRight());
            this.tile.setFacadeBlockName((String)serializedBlockState.getLeft());
        }
        this.tile.sendUpdate();
    }
}

