/*
 * Decompiled with CFR 0.152.
 */
package dev.redstudio.alfheim.mixin;

import dev.redstudio.alfheim.ProjectConstants;
import dev.redstudio.alfheim.api.IChunkLightingData;
import dev.redstudio.alfheim.api.ILightingEngineProvider;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AnvilChunkLoader.class})
public abstract class AnvilChunkLoaderMixin {
    @Unique
    private static final String NEIGHBOR_LIGHT_CHECKS_KEY = "NeighborLightChecks";

    @Inject(method={"saveChunk"}, at={@At(value="HEAD")})
    private void onConstructed(World world, Chunk chunk, CallbackInfo callbackInfo) {
        ((ILightingEngineProvider)world).getAlfheim$lightingEngine().processLightUpdates();
    }

    @Inject(method={"readChunkFromNBT"}, at={@At(value="RETURN")})
    private void onReadChunkFromNBT(World world, NBTTagCompound compound, CallbackInfoReturnable<Chunk> callbackInfoReturnable) {
        Chunk chunk = (Chunk)callbackInfoReturnable.getReturnValue();
        AnvilChunkLoaderMixin.alfheim$readNeighborLightChecksFromNBT(chunk, compound);
        ((IChunkLightingData)chunk).alfheim$setLightInitialized(compound.func_74767_n("LightPopulated"));
    }

    @Inject(method={"writeChunkToNBT"}, at={@At(value="RETURN")})
    private void onWriteChunkToNBT(Chunk chunk, World world, NBTTagCompound compound, CallbackInfo callbackInfo) {
        AnvilChunkLoaderMixin.alfheim$writeNeighborLightChecksToNBT(chunk, compound);
        compound.func_74757_a("LightPopulated", ((IChunkLightingData)chunk).alfheim$isLightInitialized());
    }

    @Unique
    private static void alfheim$readNeighborLightChecksFromNBT(Chunk chunk, NBTTagCompound compound) {
        if (!compound.func_150297_b(NEIGHBOR_LIGHT_CHECKS_KEY, 9)) {
            return;
        }
        NBTTagList tagList = compound.func_150295_c(NEIGHBOR_LIGHT_CHECKS_KEY, 2);
        if (tagList.func_74745_c() != 32) {
            ProjectConstants.LOGGER.warn("Chunk field {} had invalid length, ignoring it (chunk coordinates: {} {})", (Object)NEIGHBOR_LIGHT_CHECKS_KEY, (Object)chunk.field_76635_g, (Object)chunk.field_76647_h);
            return;
        }
        ((IChunkLightingData)chunk).alfheim$initNeighborLightChecks();
        short[] neighborLightChecks = ((IChunkLightingData)chunk).alfheim$getNeighborLightChecks();
        for (int i = 0; i < 32; ++i) {
            neighborLightChecks[i] = ((NBTTagShort)tagList.func_179238_g(i)).func_150289_e();
        }
    }

    @Unique
    private static void alfheim$writeNeighborLightChecksToNBT(Chunk chunk, NBTTagCompound compound) {
        short[] neighborLightChecks = ((IChunkLightingData)chunk).alfheim$getNeighborLightChecks();
        if (neighborLightChecks == null) {
            return;
        }
        boolean empty = true;
        NBTTagList list = new NBTTagList();
        for (short flags : neighborLightChecks) {
            list.func_74742_a((NBTBase)new NBTTagShort(flags));
            if (flags == 0) continue;
            empty = false;
        }
        if (!empty) {
            compound.func_74782_a(NEIGHBOR_LIGHT_CHECKS_KEY, (NBTBase)list);
        }
    }
}

