/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util.stackable;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.stackable.BlockThing;
import com.enderio.core.common.util.stackable.IProducer;
import com.enderio.core.common.util.stackable.IThing;
import com.enderio.core.common.util.stackable.ItemStackThing;
import com.enderio.core.common.util.stackable.ItemThing;
import com.enderio.core.common.util.stackable.OreThing;
import com.enderio.core.common.util.stackable.ProducerThing;
import com.enderio.core.common.util.stackable.ResourceThing;
import com.enderio.core.common.util.stackable.StringThing;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.oredict.OreIngredient;

public class Things
extends Ingredient {
    @Nonnull
    static final Map<String, IThing> aliases = new HashMap<String, IThing>();
    @Nonnull
    private static final List<Things> values = new ArrayList<Things>();
    private static boolean inPreInit = true;
    private static boolean beforeLoadComplete = true;
    @Nonnull
    private final List<IThing> things = new ArrayList<IThing>();
    private NBTTagCompound nbt = null;
    private int size = 1;
    @Nullable
    private NNList<Item> itemList = null;
    @Nullable
    private NNList<ItemStack> itemStackListRaw = null;
    @Nullable
    private NNList<ItemStack> itemStackList = null;
    @Nullable
    private NNList<Block> blockList = null;
    @Nonnull
    private final NNList<String> nameList = new NNList();
    @Nullable
    private IntList itemIds = null;

    public Things(String ... names) {
        super(new ItemStack[0]);
        this.init(names);
    }

    public Things() {
        super(new ItemStack[0]);
    }

    protected void init(String ... names) {
        for (String string : names) {
            this.add(string);
        }
        if (beforeLoadComplete) {
            values.add(this);
        }
    }

    public static void init(@Nullable FMLInitializationEvent event) {
        inPreInit = false;
        for (Things element : values) {
            element.bake();
        }
        values.clear();
    }

    public static void init(@Nullable FMLLoadCompleteEvent event) {
        beforeLoadComplete = false;
        for (Things element : values) {
            element.doublebake();
        }
        values.clear();
    }

    public void setNbt(NBTTagCompound nbt) {
        this.nbt = nbt;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Nonnull
    public Things add(@Nullable Item item) {
        if (item != null) {
            this.nameList.add("item:" + item.getRegistryName());
            this.add(new ItemThing(item));
        }
        return this;
    }

    public Things add(NNList<?> list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (o instanceof String) {
                this.add((String)o);
                continue;
            }
            if (o instanceof Item) {
                this.add((Item)o);
                continue;
            }
            if (o instanceof Block) {
                this.add((Block)o);
                continue;
            }
            if (o instanceof IProducer) {
                this.add((IProducer)o);
                continue;
            }
            if (o instanceof ItemStack) {
                this.add((ItemStack)o);
                continue;
            }
            if (o instanceof ResourceLocation) {
                this.add((ResourceLocation)o);
                continue;
            }
            if (o instanceof Things) {
                this.add((Things)((Object)o));
                continue;
            }
            if (o instanceof NNList) {
                this.add((NNList)((Object)o));
                continue;
            }
            throw new RuntimeException("Class " + o.getClass() + " is not suitable for Things");
        }
        return this;
    }

    @Nonnull
    public Things add(@Nullable ItemStack itemStack) {
        if (itemStack != null && !itemStack.func_190926_b()) {
            this.nameList.add("item:" + itemStack.func_77973_b().getRegistryName());
            this.add(new ItemStackThing(itemStack));
        }
        return this;
    }

    @Nonnull
    public Things add(@Nullable Block block) {
        if (block != null) {
            this.nameList.add("block:" + block.getRegistryName());
            this.add(new BlockThing(block));
        }
        return this;
    }

    @Nonnull
    public Things add(@Nullable String name) {
        if (name != null) {
            this.nameList.add(name);
            this.add(new StringThing(name));
        }
        return this;
    }

    @Nonnull
    public Things add(@Nullable IProducer producer) {
        if (producer != null) {
            Item item;
            Block block = producer.getBlock();
            if (block != null) {
                this.nameList.add("block:" + block.getRegistryName());
            }
            if ((item = producer.getItem()) != null) {
                this.nameList.add("item:" + item.getRegistryName());
            }
            this.add(new ProducerThing(producer));
        }
        return this;
    }

    public static void addAlias(@Nullable String name, @Nullable String value) {
        if (name != null && value != null) {
            aliases.put(name, new StringThing(value));
        }
    }

    @Nonnull
    public Things add(@Nullable ResourceLocation resourceLocation) {
        if (resourceLocation != null) {
            Item item;
            if (Block.field_149771_c.func_148741_d((Object)resourceLocation)) {
                Block block = (Block)Block.field_149771_c.func_82594_a((Object)resourceLocation);
                this.nameList.add("block:" + block.getRegistryName());
            }
            if ((item = (Item)Item.field_150901_e.func_82594_a((Object)resourceLocation)) != null) {
                this.nameList.add("item:" + item.getRegistryName());
            }
            this.add(new ResourceThing(resourceLocation));
        }
        return this;
    }

    @Nonnull
    public Things addOredict(@Nullable String name) {
        if (name != null) {
            this.nameList.add("oredict:" + name);
            this.add(new OreThing(name));
        }
        return this;
    }

    @Nonnull
    public Things add(@Nullable Things otherThings) {
        if (otherThings != null) {
            this.nameList.addAll((Collection)((Object)otherThings.nameList));
            for (IThing thing : otherThings.things) {
                this.add(thing);
            }
        }
        return this;
    }

    private void add(@Nullable IThing thing) {
        if (thing != null) {
            if (!inPreInit) {
                Iterator iterator = thing.bake().iterator();
                while (iterator.hasNext()) {
                    IThing baked = (IThing)iterator.next();
                    this.things.add(baked);
                }
            } else {
                this.things.add(thing);
            }
        }
        this.cleanCachedValues();
    }

    private void cleanCachedValues() {
        this.itemList = null;
        this.itemStackListRaw = null;
        this.itemStackList = null;
        this.blockList = null;
        this.itemIds = null;
    }

    private void bake() {
        NNList temp = new NNList();
        for (IThing thing : this.things) {
            Iterator iterator = thing.bake().iterator();
            while (iterator.hasNext()) {
                IThing baked = (IThing)iterator.next();
                temp.add(baked);
            }
        }
        this.things.clear();
        this.things.addAll((Collection<IThing>)((Object)temp));
        this.cleanCachedValues();
    }

    private void doublebake() {
        for (int i = 0; i < this.things.size(); ++i) {
            IThing thing = this.things.get(i);
            if (!(thing instanceof IThing.Zwieback)) continue;
            IThing bakedThing = ((IThing.Zwieback)thing).rebake();
            if (bakedThing != null) {
                this.things.set(i, bakedThing);
            } else {
                this.things.remove(i);
                --i;
            }
            this.cleanCachedValues();
        }
    }

    public boolean contains(@Nullable Item item) {
        if (item != Items.field_190931_a) {
            for (IThing thing : this.things) {
                if (!thing.is(item)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(@Nullable ItemStack itemStack) {
        if (itemStack != null && !itemStack.func_190926_b()) {
            for (IThing thing : this.things) {
                if (!thing.is(itemStack) || this.nbt != null && !this.nbt.equals((Object)itemStack.func_77978_p())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(@Nullable Block block) {
        if (block != Blocks.field_150350_a) {
            for (IThing thing : this.things) {
                if (!thing.is(block)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.things.isEmpty();
    }

    public boolean isValid() {
        if (inPreInit) {
            Things temp = new Things();
            temp.add(this.getNameList());
            temp.bake();
            return !temp.getItemStacksRaw().isEmpty();
        }
        return !this.getItemStacksRaw().isEmpty();
    }

    public boolean isPotentiallyValid() {
        if (this.isValid()) {
            return true;
        }
        if (beforeLoadComplete) {
            for (IThing thing : this.things) {
                if (!(thing instanceof IThing.Zwieback)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public NNList<Item> getItems() {
        NNList<Object> list = this.itemList;
        if (list == null || list.isEmpty() || beforeLoadComplete) {
            list = new NNList();
            for (IThing thing : this.things) {
                list.addAll((Collection)((Object)thing.getItems()));
            }
        }
        this.itemList = list;
        return this.itemList;
    }

    @Nonnull
    public NNList<ItemStack> getItemStacksRaw() {
        NNList<Object> list = this.itemStackListRaw;
        if (list == null || list.isEmpty() || beforeLoadComplete) {
            list = new NNList();
            for (IThing thing : this.things) {
                list.addAll((Collection)((Object)thing.getItemStacks()));
            }
            this.applyNBT(list);
        }
        this.itemStackListRaw = list;
        return this.itemStackListRaw;
    }

    private void applyNBT(NNList<ItemStack> list) {
        if (this.nbt != null || this.size > 1) {
            for (int i = 0; i < list.size(); ++i) {
                ItemStack stack = list.get(i).func_77946_l();
                if (this.nbt != null) {
                    stack.func_77982_d(this.nbt.func_74737_b());
                }
                if (this.size > 1) {
                    stack.func_190920_e(this.size);
                }
                list.set(i, stack);
            }
        }
    }

    @Nonnull
    public NNList<ItemStack> getItemStacks() {
        NNList<Object> list = this.itemStackList;
        if (list == null || list.isEmpty() || beforeLoadComplete) {
            list = new NNList();
            Iterator iterator = this.getItemStacksRaw().iterator();
            while (iterator.hasNext()) {
                ItemStack stack = (ItemStack)iterator.next();
                if (stack.func_190926_b()) continue;
                if (stack.func_77952_i() == Short.MAX_VALUE) {
                    stack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, list);
                    continue;
                }
                list.add(stack);
            }
            this.applyNBT(list);
        }
        this.itemStackList = list;
        return this.itemStackList;
    }

    @Nonnull
    public ItemStack getItemStack() {
        NNList<ItemStack> itemStacks = this.getItemStacks();
        return itemStacks.isEmpty() ? ItemStack.field_190927_a : itemStacks.get(0);
    }

    @Nonnull
    public NNList<Block> getBlocks() {
        NNList<Object> list = this.blockList;
        if (list == null || list.isEmpty() || beforeLoadComplete) {
            list = new NNList();
            for (IThing thing : this.things) {
                list.addAll((Collection)((Object)thing.getBlocks()));
            }
        }
        this.blockList = list;
        return this.blockList;
    }

    @Nonnull
    public NNList<String> getNameList() {
        return this.nameList;
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        return this.getItemStacks().toArray(new ItemStack[0]);
    }

    public boolean apply(@Nullable ItemStack p_apply_1_) {
        return this.contains(p_apply_1_);
    }

    @Nonnull
    public IntList func_194139_b() {
        IntList list = this.itemIds;
        if (list == null || list.isEmpty() || beforeLoadComplete) {
            list = new IntArrayList();
            NNList.NNIterator<ItemStack> itr = this.getItemStacks().fastIterator();
            while (itr.hasNext()) {
                list.add(RecipeItemHelper.func_194113_b((ItemStack)itr.next()));
            }
        }
        this.itemIds = list;
        return this.itemIds;
    }

    protected void invalidate() {
        NNList<String> names = this.nameList.copy();
        this.nameList.clear();
        this.things.clear();
        this.add(names);
    }

    public boolean isSimple() {
        return false;
    }

    @Nonnull
    public Ingredient asIngredient() {
        NNList ings = new NNList();
        for (IThing thing : this.things) {
            if (thing instanceof OreThing) {
                if (this.nbt != null) {
                    ings.add((Object)new OreIngredientNBT(((OreThing)thing).getName(), this.nbt));
                    continue;
                }
                ings.add(new OreIngredient(((OreThing)thing).getName()){

                    public String toString() {
                        return "OreIngredient " + Arrays.toString(this.func_193365_a());
                    }
                });
                continue;
            }
            NNList<ItemStack> sublist = new NNList<ItemStack>();
            Iterator iterator = thing.getItemStacks().iterator();
            while (iterator.hasNext()) {
                ItemStack stack = (ItemStack)iterator.next();
                if (stack.func_190926_b()) continue;
                if (stack.func_77952_i() == Short.MAX_VALUE) {
                    stack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, sublist);
                    continue;
                }
                sublist.add(stack);
            }
            this.applyNBT(sublist);
            iterator = sublist.iterator();
            while (iterator.hasNext()) {
                ItemStack itemStack = (ItemStack)iterator.next();
                if (this.nbt != null) {
                    ings.add(new IngredientNBT(itemStack){

                        public String toString() {
                            return "IngredientNBT " + Arrays.toString(this.func_193365_a());
                        }
                    });
                    continue;
                }
                ings.add(new Ingredient(new ItemStack[]{itemStack}){

                    public String toString() {
                        return "Ingredient " + Arrays.toString(this.func_193365_a());
                    }
                });
            }
        }
        if (ings.isEmpty()) {
            return this;
        }
        if (ings.size() == 1) {
            return (Ingredient)ings.get(0);
        }
        return new CompoundIngredient((Collection)((Object)ings)){

            public String toString() {
                return "CompoundIngredient " + Arrays.toString(this.func_193365_a());
            }
        };
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Things [");
        builder.append("things=");
        builder.append(this.things);
        builder.append(", ");
        builder.append("size=");
        builder.append(this.size);
        builder.append(", ");
        if (this.nbt != null) {
            builder.append("nbt=");
            builder.append(this.nbt);
        }
        builder.append("]");
        return builder.toString();
    }

    private static class OreIngredientNBT
    extends OreIngredient {
        @Nonnull
        private final NBTTagCompound nbt;

        public OreIngredientNBT(@Nonnull String ore, @Nonnull NBTTagCompound nbt) {
            super(ore);
            this.nbt = nbt;
        }

        public boolean apply(@Nullable ItemStack input) {
            return super.apply(input) && input != null && this.nbt.equals((Object)input.func_77978_p());
        }

        @Nonnull
        public ItemStack[] func_193365_a() {
            ItemStack[] matchingStacks;
            for (ItemStack itemStack : matchingStacks = super.func_193365_a()) {
                itemStack.func_77982_d(this.nbt.func_74737_b());
            }
            return matchingStacks;
        }

        public boolean isSimple() {
            return false;
        }

        public String toString() {
            return "OreIngredientNBT(" + this.nbt + ") " + Arrays.toString(this.func_193365_a());
        }
    }
}

