/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class MagnetUtil {
    @Nonnull
    private static final String PREVENT_REMOTE_MOVEMENT = "PreventRemoteMovement";
    @Nonnull
    private static final String ALLOW_MACHINE_MOVEMENT = "AllowMachineRemoteMovement";
    @Nonnull
    public static final String EC_PULLER_TAG = "ECpuller";

    @Deprecated
    public static boolean shouldAttract(@Nullable BlockPos pullerPos, @Nullable Entity entity) {
        return MagnetUtil.shouldAttract(pullerPos, entity, false);
    }

    public static boolean shouldAttract(@Nullable BlockPos pullerPos, @Nullable Entity entity, boolean isMachine) {
        if (entity == null || entity.field_70128_L) {
            return false;
        }
        if (entity instanceof IProjectile && entity.field_70181_x > 0.01) {
            return false;
        }
        NBTTagCompound data = entity.getEntityData();
        if (MagnetUtil.isReservedByOthers(data, isMachine)) {
            return false;
        }
        if (!MagnetUtil.isReservedByUs(data)) {
            MagnetUtil.reserve(data, pullerPos);
            return true;
        }
        if (pullerPos == null) {
            return false;
        }
        long posL = data.func_74763_f(EC_PULLER_TAG);
        if (posL == pullerPos.func_177986_g()) {
            return true;
        }
        BlockPos curOwner = BlockPos.func_177969_a((long)posL);
        double distToCur = curOwner.func_177957_d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        double distToMe = pullerPos.func_177957_d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (distToMe + 1.0 < distToCur) {
            MagnetUtil.reserve(data, pullerPos);
            return true;
        }
        return false;
    }

    public static void reserve(@Nullable Entity entity, @Nullable BlockPos pullerPos) {
        if (entity != null && !entity.field_70128_L) {
            NBTTagCompound data = entity.getEntityData();
            MagnetUtil.reserve(data, pullerPos);
        }
    }

    public static void reserve(@Nonnull NBTTagCompound data, @Nullable BlockPos pullerPos) {
        if (pullerPos != null) {
            data.func_74772_a(EC_PULLER_TAG, pullerPos.func_177986_g());
        }
    }

    public static void release(@Nullable Entity entity) {
        if (entity != null && !entity.field_70128_L) {
            NBTTagCompound data = entity.getEntityData();
            MagnetUtil.release(data);
        }
    }

    public static void release(@Nonnull NBTTagCompound data) {
        data.func_82580_o(EC_PULLER_TAG);
    }

    @Deprecated
    public static boolean isReserved(@Nonnull Entity entity) {
        return MagnetUtil.isReserved(entity, false);
    }

    public static boolean isReserved(@Nonnull Entity entity, boolean isMachine) {
        return MagnetUtil.isReservedByUs(entity.getEntityData()) || MagnetUtil.isReservedByOthers(entity.getEntityData(), isMachine);
    }

    public static boolean isReservedByUs(@Nonnull NBTTagCompound data) {
        return data.func_74764_b(EC_PULLER_TAG);
    }

    @Deprecated
    public static boolean isReservedByOthers(@Nonnull NBTTagCompound data) {
        return MagnetUtil.isReservedByOthers(data, false);
    }

    public static boolean isReservedByOthers(@Nonnull NBTTagCompound data, boolean isMachine) {
        return data.func_74764_b(PREVENT_REMOTE_MOVEMENT) && (!isMachine || !data.func_74764_b(ALLOW_MACHINE_MOVEMENT));
    }
}

