/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.handlers;

import com.enderio.core.EnderCore;
import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.Handlers;
import com.enderio.core.common.config.ConfigHandler;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;

@Handlers.Handler
public class SpecialTooltipHandler {
    @Nonnull
    private static final List<ITooltipCallback> callbacks = new ArrayList<ITooltipCallback>();
    @Nonnull
    private static final List<String> throwaway = new ArrayList<String>();

    public static void addCallback(@Nonnull ITooltipCallback callback) {
        callbacks.add(callback);
    }

    @SubscribeEvent
    public static void addTooltip(ItemTooltipEvent evt) {
        if (evt.getItemStack().func_190926_b()) {
            return;
        }
        boolean flag = SpecialTooltipHandler.showAdvancedTooltips();
        boolean doDurability = SpecialTooltipHandler.showDurability(evt.getFlags().func_194127_a());
        if (doDurability) {
            SpecialTooltipHandler.addDurabilityTooltip(SpecialTooltipHandler.getTooltip(evt), evt.getItemStack());
        }
        if (evt.getItemStack().func_77973_b() instanceof IAdvancedTooltipProvider) {
            IAdvancedTooltipProvider ttp = (IAdvancedTooltipProvider)evt.getItemStack().func_77973_b();
            SpecialTooltipHandler.addInformation(ttp, evt.getItemStack(), evt.getEntityPlayer(), SpecialTooltipHandler.getTooltip(evt), flag);
        } else if (evt.getItemStack().func_77973_b() instanceof IResourceTooltipProvider) {
            SpecialTooltipHandler.addInformation((IResourceTooltipProvider)evt.getItemStack().func_77973_b(), evt, flag);
        } else {
            Block blk = Block.func_149634_a((Item)evt.getItemStack().func_77973_b());
            if (blk instanceof IAdvancedTooltipProvider) {
                SpecialTooltipHandler.addInformation((IAdvancedTooltipProvider)blk, evt.getItemStack(), evt.getEntityPlayer(), SpecialTooltipHandler.getTooltip(evt), flag);
            } else if (blk instanceof IResourceTooltipProvider) {
                SpecialTooltipHandler.addInformation((IResourceTooltipProvider)blk, evt, flag);
            }
        }
        for (ITooltipCallback callback : callbacks) {
            if (!callback.shouldHandleItem(evt.getItemStack())) continue;
            SpecialTooltipHandler.addInformation(callback, evt.getItemStack(), evt.getEntityPlayer(), SpecialTooltipHandler.getTooltip(evt), flag);
        }
    }

    public static boolean showDurability(boolean shiftDown) {
        return ConfigHandler.showDurabilityTooltips == 3 ? Minecraft.func_71410_x().field_71474_y.field_82882_x : (ConfigHandler.showDurabilityTooltips == 2 ? shiftDown : ConfigHandler.showDurabilityTooltips == 1);
    }

    public static NNList<String> getAllTooltips(ItemStack stack) {
        NNList<String> list = new NNList<String>();
        if (stack.func_77973_b() instanceof IAdvancedTooltipProvider) {
            IAdvancedTooltipProvider tt = (IAdvancedTooltipProvider)stack.func_77973_b();
            tt.addCommonEntries(stack, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, (List<String>)((Object)list), false);
            tt.addBasicEntries(stack, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, (List<String>)((Object)list), false);
            tt.addDetailedEntries(stack, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, (List<String>)((Object)list), false);
        } else if (stack.func_77973_b() instanceof IResourceTooltipProvider) {
            String name = ((IResourceTooltipProvider)stack.func_77973_b()).getUnlocalizedNameForTooltip(stack);
            SpecialTooltipHandler.addCommonTooltipFromResources(list, name);
            SpecialTooltipHandler.addBasicTooltipFromResources(list, name);
            SpecialTooltipHandler.addDetailedTooltipFromResources(list, name);
        } else {
            Object tt;
            Block blk = Block.func_149634_a((Item)stack.func_77973_b());
            if (blk instanceof IAdvancedTooltipProvider) {
                tt = (IAdvancedTooltipProvider)blk;
                tt.addCommonEntries(stack, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, (List<String>)((Object)list), false);
                tt.addBasicEntries(stack, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, (List<String>)((Object)list), false);
                tt.addDetailedEntries(stack, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, (List<String>)((Object)list), false);
            } else if (blk instanceof IResourceTooltipProvider) {
                tt = (IResourceTooltipProvider)blk;
                String name = tt.getUnlocalizedNameForTooltip(stack);
                SpecialTooltipHandler.addCommonTooltipFromResources(list, name);
                SpecialTooltipHandler.addBasicTooltipFromResources(list, name);
                SpecialTooltipHandler.addDetailedTooltipFromResources(list, name);
            }
        }
        for (ITooltipCallback callback : callbacks) {
            if (!callback.shouldHandleItem(stack)) continue;
            callback.addCommonEntries(stack, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, (List<String>)((Object)list), false);
            callback.addBasicEntries(stack, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, (List<String>)((Object)list), false);
            callback.addDetailedEntries(stack, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, (List<String>)((Object)list), false);
        }
        return list;
    }

    public static void addDurabilityTooltip(@Nonnull List<String> toolTip, @Nonnull ItemStack itemStack) {
        if (!itemStack.func_77984_f()) {
            return;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemTool || item instanceof ItemArmor || item instanceof ItemSword || item instanceof ItemHoe || item instanceof ItemBow || item instanceof ItemShears) {
            toolTip.add(ItemUtil.getDurabilityString(itemStack));
        }
    }

    public static void addInformation(@Nonnull IResourceTooltipProvider item, @Nonnull ItemTooltipEvent evt, boolean flag) {
        SpecialTooltipHandler.addInformation(item, evt.getItemStack(), evt.getEntityPlayer(), SpecialTooltipHandler.getTooltip(evt), flag);
    }

    @Nonnull
    private static List<String> getTooltip(@Nonnull ItemTooltipEvent event) {
        List toolTip = event.getToolTip();
        if (toolTip == null) {
            throw new NullPointerException("How should we add a tooltip into a null list???");
        }
        return toolTip;
    }

    public static void addInformation(@Nonnull IResourceTooltipProvider tt, @Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        String name = tt.getUnlocalizedNameForTooltip(itemstack);
        if (flag) {
            SpecialTooltipHandler.addCommonTooltipFromResources(list, name);
            SpecialTooltipHandler.addDetailedTooltipFromResources(list, name);
        } else {
            SpecialTooltipHandler.addBasicTooltipFromResources(list, name);
            SpecialTooltipHandler.addCommonTooltipFromResources(list, name);
            if (SpecialTooltipHandler.hasDetailedTooltip(tt, itemstack)) {
                SpecialTooltipHandler.addShowDetailsTooltip(list);
            }
        }
    }

    public static void addInformation(@Nonnull IAdvancedTooltipProvider tt, @Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        tt.addCommonEntries(itemstack, entityplayer, list, false);
        if (flag) {
            tt.addDetailedEntries(itemstack, entityplayer, list, false);
        } else {
            tt.addBasicEntries(itemstack, entityplayer, list, false);
            if (SpecialTooltipHandler.hasDetailedTooltip(tt, itemstack, entityplayer, false)) {
                SpecialTooltipHandler.addShowDetailsTooltip(list);
            }
        }
    }

    private static boolean hasDetailedTooltip(@Nonnull IResourceTooltipProvider tt, @Nonnull ItemStack stack) {
        throwaway.clear();
        String name = tt.getUnlocalizedNameForTooltip(stack);
        SpecialTooltipHandler.addDetailedTooltipFromResources(throwaway, name);
        return !throwaway.isEmpty();
    }

    private static boolean hasDetailedTooltip(@Nonnull IAdvancedTooltipProvider tt, @Nonnull ItemStack stack, @Nullable EntityPlayer player, boolean flag) {
        throwaway.clear();
        tt.addDetailedEntries(stack, player, throwaway, flag);
        return !throwaway.isEmpty();
    }

    public static void addShowDetailsTooltip(@Nonnull List<String> list) {
        list.add(TextFormatting.WHITE + "" + TextFormatting.ITALIC + EnderCore.lang.localize("tooltip.showDetails"));
    }

    public static void addDetailedTooltipFromResources(@Nonnull List<String> list, @Nonnull String unlocalizedName) {
        SpecialTooltipHandler.addMultilineTooltip(list, unlocalizedName, ".tooltip.detailed");
    }

    public static void addBasicTooltipFromResources(@Nonnull List<String> list, @Nonnull String unlocalizedName) {
        SpecialTooltipHandler.addMultilineTooltip(list, unlocalizedName, ".tooltip.basic");
    }

    public static void addCommonTooltipFromResources(@Nonnull List<String> list, @Nonnull String unlocalizedName) {
        SpecialTooltipHandler.addMultilineTooltip(list, unlocalizedName, ".tooltip.common");
    }

    public static void addMultilineTooltip(@Nonnull List<String> list, String ... keyParts) {
        String key = String.join((CharSequence)"", keyParts);
        if (EnderCore.lang.canLocalizeExact(key + ".line1")) {
            SpecialTooltipHandler.addTooltipFromResources(list, key + ".line");
        } else if (EnderCore.lang.canLocalizeExact(key)) {
            list.addAll(Arrays.asList(EnderCore.lang.localizeListExact(key)));
        }
    }

    @Deprecated
    public static void addTooltipFromResources(@Nonnull List<String> list, @Nullable String keyBase) {
        boolean done = false;
        int line = 1;
        while (!done) {
            String key = keyBase + line;
            String val = EnderCore.lang.localizeExact(key);
            if (val.trim().length() < 0 || val.equals(key) || line > 12) {
                done = true;
                continue;
            }
            list.add(val);
            ++line;
        }
    }

    @Nonnull
    private static String getUnlocalizedNameForTooltip(@Nonnull ItemStack itemstack) {
        String unlocalizedNameForTooltip = null;
        if (itemstack.func_77973_b() instanceof IResourceTooltipProvider) {
            unlocalizedNameForTooltip = ((IResourceTooltipProvider)itemstack.func_77973_b()).getUnlocalizedNameForTooltip(itemstack);
        }
        if (unlocalizedNameForTooltip == null) {
            unlocalizedNameForTooltip = itemstack.func_77973_b().func_77667_c(itemstack);
        }
        return unlocalizedNameForTooltip;
    }

    public static void addCommonTooltipFromResources(@Nonnull List<String> list, @Nonnull ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return;
        }
        SpecialTooltipHandler.addCommonTooltipFromResources(list, SpecialTooltipHandler.getUnlocalizedNameForTooltip(itemstack));
    }

    public static void addDetailedTooltipFromResources(@Nonnull List<String> list, @Nonnull ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return;
        }
        SpecialTooltipHandler.addDetailedTooltipFromResources(list, SpecialTooltipHandler.getUnlocalizedNameForTooltip(itemstack));
    }

    private SpecialTooltipHandler() {
    }

    public static boolean showAdvancedTooltips() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static interface ITooltipCallback
    extends IAdvancedTooltipProvider {
        public boolean shouldHandleItem(@Nonnull ItemStack var1);
    }
}

