/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.button;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.EnderWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;

public class ToggleButton
extends IconButton {
    private boolean selected;
    @Nonnull
    private final IWidgetIcon unselectedIcon;
    @Nonnull
    private final IWidgetIcon selectedIcon;
    private GuiToolTip selectedTooltip;
    private GuiToolTip unselectedTooltip;
    private boolean paintSelectionBorder;

    public ToggleButton(@Nonnull IGuiScreen gui, int id, int x, int y, @Nonnull IWidgetIcon unselectedIcon, @Nonnull IWidgetIcon selectedIcon) {
        super(gui, id, x, y, unselectedIcon);
        this.unselectedIcon = unselectedIcon;
        this.selectedIcon = selectedIcon;
        this.selected = false;
        this.paintSelectionBorder = true;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public ToggleButton setSelected(boolean selected) {
        this.selected = selected;
        IWidgetIcon iWidgetIcon = this.icon = selected ? this.selectedIcon : this.unselectedIcon;
        if (selected && this.selectedTooltip != null) {
            this.setToolTip(this.selectedTooltip);
        } else if (!selected && this.unselectedTooltip != null) {
            this.setToolTip(this.unselectedTooltip);
        }
        return this;
    }

    @Override
    @Nonnull
    protected IWidgetIcon getIconForHoverState(int hoverState) {
        if (!this.selected || !this.paintSelectionBorder) {
            return super.getIconForHoverState(hoverState);
        }
        if (hoverState == 0) {
            return EnderWidget.BUTTON_DISABLED;
        }
        if (hoverState == 2) {
            return EnderWidget.BUTTON_DOWN_HIGHLIGHT;
        }
        return EnderWidget.BUTTON_DOWN;
    }

    @Override
    public boolean mousePressedButton(@Nonnull Minecraft mc, int mouseX, int mouseY, int button) {
        if (super.checkMousePress(mc, mouseX, mouseY) && button == 0) {
            this.toggleSelected();
            return true;
        }
        return false;
    }

    protected boolean toggleSelected() {
        this.setSelected(!this.selected);
        return true;
    }

    public void setSelectedToolTip(String ... tt) {
        this.selectedTooltip = new GuiToolTip(this.getBounds(), this.makeCombinedTooltipList(tt));
        this.setSelected(this.selected);
    }

    @Nonnull
    private List<String> makeCombinedTooltipList(String ... tt) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.toolTipText != null) {
            Collections.addAll(list, this.toolTipText);
        }
        Collections.addAll(list, tt);
        return list;
    }

    public void setUnselectedToolTip(String ... tt) {
        this.unselectedTooltip = new GuiToolTip(this.getBounds(), this.makeCombinedTooltipList(tt));
        this.setSelected(this.selected);
    }

    public void setPaintSelectedBorder(boolean b) {
        this.paintSelectionBorder = b;
    }
}

