/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.modularmagic.common.network;

import fr.frinn.modularmagic.common.tile.TileStarlightInput;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class StarlightMessage
implements IMessage {
    public int starlightAmount;
    public BlockPos pos;

    public StarlightMessage() {
    }

    public StarlightMessage(int starlightAmount, BlockPos pos) {
        this.starlightAmount = starlightAmount;
        this.pos = pos;
    }

    public void fromBytes(ByteBuf buf) {
        this.starlightAmount = buf.readInt();
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.starlightAmount);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
    }

    public static class StarlightMessageHandler
    implements IMessageHandler<StarlightMessage, IMessage> {
        public IMessage onMessage(StarlightMessage message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                TileEntity te = ctx.getServerHandler().field_147369_b.field_70170_p.func_175625_s(message.pos);
                if (te != null && te instanceof TileStarlightInput) {
                    TileStarlightInput starlightInput = (TileStarlightInput)te;
                    return new StarlightMessage(starlightInput.getStarlightStored(), starlightInput.func_174877_v());
                }
            } else if (ctx.side == Side.CLIENT) {
                TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(message.pos);
                if (te != null && te instanceof TileStarlightInput) {
                    TileStarlightInput starlightInput = (TileStarlightInput)te;
                    Minecraft.func_71410_x().func_152344_a(() -> ((TileStarlightInput)te).setStarlight(message.starlightAmount));
                }
                return null;
            }
            return null;
        }
    }
}

