/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.modularmagic.common.crafting.requirement;

import WayofTime.bloodmagic.soul.EnumDemonWillType;
import com.google.common.collect.Lists;
import fr.frinn.modularmagic.common.integration.jei.component.JEIComponentWill;
import fr.frinn.modularmagic.common.tile.TileWillProvider;
import fr.frinn.modularmagic.common.tile.machinecomponent.MachineComponentWillProvider;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.List;
import javax.annotation.Nonnull;

public class RequirementWill
extends ComponentRequirement {
    public double willAmount;
    public EnumDemonWillType willType;

    public RequirementWill(MachineComponent.IOType actionType, double willRequired, EnumDemonWillType willType) {
        super(ComponentType.Registry.getComponent((String)"will"), actionType);
        this.willAmount = willRequired;
        this.willType = willType;
    }

    public boolean startCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance chance) {
        if (!this.canStartCrafting(component, context, Lists.newArrayList()).isSuccess()) {
            return false;
        }
        if (this.getActionType() == MachineComponent.IOType.INPUT) {
            TileWillProvider willProvider = (TileWillProvider)((Object)component.getContainerProvider());
            willProvider.removeWill(this.willAmount, this.willType);
        }
        return true;
    }

    public boolean finishCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance chance) {
        if (this.getActionType() == MachineComponent.IOType.OUTPUT) {
            TileWillProvider willProvider = (TileWillProvider)((Object)component.getContainerProvider());
            willProvider.addWill(this.willAmount, this.willType);
        }
        return true;
    }

    @Nonnull
    public CraftCheck canStartCrafting(MachineComponent component, RecipeCraftingContext context, List restrictions) {
        if (!component.getComponentType().equals((Object)this.getRequiredComponentType()) || !(component instanceof MachineComponentWillProvider) || component.getIOType() != this.getActionType()) {
            return CraftCheck.skipComponent();
        }
        TileWillProvider willProvider = (TileWillProvider)((Object)component.getContainerProvider());
        switch (this.getActionType()) {
            case INPUT: {
                if (willProvider.getWill(this.willType) >= this.willAmount) {
                    return CraftCheck.success();
                }
                return CraftCheck.failure((String)"error.modularmagic.requirement.will.less");
            }
            case OUTPUT: {
                return CraftCheck.success();
            }
        }
        return CraftCheck.failure((String)"error.modularmagic.requirement.will");
    }

    public ComponentRequirement deepCopy() {
        return this;
    }

    public ComponentRequirement deepCopyModified(List list) {
        return this;
    }

    public void startRequirementCheck(ResultChance contextChance, RecipeCraftingContext context) {
    }

    public void endRequirementCheck() {
    }

    public ComponentRequirement.JEIComponent provideJEIComponent() {
        return new JEIComponentWill(this);
    }
}

