/*
 * Decompiled with CFR 0.152.
 */
package dev.aura.justenoughreactors.reactors.recipe;

import com.google.common.collect.ImmutableList;
import dev.aura.justenoughreactors.jei.reactor.ReactorCategory;
import dev.aura.justenoughreactors.jei.reactor.ReactorEntry;
import dev.aura.justenoughreactors.jei.reactor.ReactorWrapper;
import dev.aura.justenoughreactors.reactors.ExtremeReactorsData;
import dev.aura.justenoughreactors.util.OreDictHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import erogenousbeef.bigreactors.init.BrBlocks;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public final class ReactorRecipes {
    public static void registerReactorCategory(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new ReactorCategory(registry)});
    }

    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"}, justification="BrBlocks.* won't be null at runtime!")
    public static void registerReactorRecipes(IModRegistry registry) {
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BrBlocks.reactorCasing), new String[]{"justenoughreactors:reactor"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BrBlocks.reactorGlass), new String[]{"justenoughreactors:reactor"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BrBlocks.reactorController), new String[]{"justenoughreactors:reactor"});
        ImmutableList<String> blocks = ReactorRecipes.getBlocks();
        ImmutableList<String> fluids = ReactorRecipes.getFluids();
        registry.addRecipes((Collection)Stream.concat(blocks.stream().filter(OreDictHelper::doesOreExist).map(ReactorEntry::newBlock), fluids.stream().filter(OreDictHelper::doesFluidExist).map(ReactorEntry::newFluid)).map(ReactorWrapper::new).collect(Collectors.toList()), "justenoughreactors:reactor");
    }

    private static ImmutableList<String> getBlocks() {
        return ImmutableList.copyOf((Collection)ExtremeReactorsData.ReactorInterior_reactorModeratorBlocks.keySet());
    }

    private static ImmutableList<String> getFluids() {
        return ImmutableList.copyOf((Collection)ExtremeReactorsData.ReactorInterior_reactorModeratorFluids.keySet());
    }

    @Generated
    private ReactorRecipes() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

