/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.world.mapgen;

import java.util.Random;
import mcjty.rftoolsdim.dimensions.world.GenericChunkGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.BaseTerrainGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class MapGenLiquidOrbs {
    private final GenericChunkGenerator provider;
    private final boolean large;
    private final int r;

    public MapGenLiquidOrbs(GenericChunkGenerator provider, boolean large) {
        this.provider = provider;
        this.large = large;
        this.r = large ? 2 : 1;
    }

    public void generate(World world, int chunkX, int chunkZ, ChunkPrimer primer) {
        IBlockState[] blocks = this.large ? this.provider.dimensionInformation.getHugeLiquidSphereBlocks() : this.provider.dimensionInformation.getLiquidSphereBlocks();
        Block[] fluids = this.large ? this.provider.dimensionInformation.getHugeLiquidSphereFluids() : this.provider.dimensionInformation.getLiquidSphereFluids();
        for (int cx = -this.r; cx <= this.r; ++cx) {
            for (int cz = -this.r; cz <= this.r; ++cz) {
                Random random = new Random((world.func_72905_C() + (long)(chunkX + cx)) * 37L + (long)((chunkZ + cz) * 5) + 113L);
                random.nextFloat();
                if (!(random.nextFloat() < 0.05f)) continue;
                int x = cx * 16 + random.nextInt(16);
                int y = 40 + random.nextInt(40);
                int z = cz * 16 + random.nextInt(16);
                int radius = random.nextInt(this.large ? 20 : 6) + (this.large ? 10 : 4);
                IBlockState block = Blocks.field_150348_b.func_176223_P();
                if (blocks.length > 1) {
                    block = blocks[random.nextInt(blocks.length)];
                } else if (blocks.length == 1) {
                    block = blocks[0];
                }
                BlockStaticLiquid fluid = Blocks.field_150355_j;
                if (fluids.length > 1) {
                    fluid = fluids[random.nextInt(fluids.length)];
                } else if (fluids.length == 1) {
                    fluid = fluids[0];
                }
                this.fillSphere(primer, x, y, z, radius, block, (Block)fluid);
            }
        }
    }

    private void fillSphere(ChunkPrimer primer, int centerx, int centery, int centerz, int radius, IBlockState block, Block fluid) {
        double sqradius = radius * radius;
        double liquidradius = ((double)radius - 1.5) * ((double)radius - 1.5);
        for (int x = 0; x < 16; ++x) {
            double dxdx = (x - centerx) * (x - centerx);
            for (int z = 0; z < 16; ++z) {
                double dzdz = (z - centerz) * (z - centerz);
                int index = (x * 16 + z) * 256;
                for (int y = centery - radius; y <= centery + radius; ++y) {
                    double dydy = (y - centery) * (y - centery);
                    double sqdist = dxdx + dydy + dzdz;
                    if (sqdist < liquidradius) {
                        BaseTerrainGenerator.setBlockState(primer, index + y, fluid.func_176223_P());
                        continue;
                    }
                    if (!(sqdist <= sqradius)) continue;
                    BaseTerrainGenerator.setBlockState(primer, index + y, block);
                }
            }
        }
    }
}

