/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.dimlets.types;

import java.util.HashMap;
import java.util.Map;
import mcjty.rftoolsdim.dimensions.dimlets.types.BiomeDimletType;
import mcjty.rftoolsdim.dimensions.dimlets.types.ControllerDimletType;
import mcjty.rftoolsdim.dimensions.dimlets.types.DigitDimletType;
import mcjty.rftoolsdim.dimensions.dimlets.types.EffectDimletType;
import mcjty.rftoolsdim.dimensions.dimlets.types.FeatureDimletType;
import mcjty.rftoolsdim.dimensions.dimlets.types.IDimletType;
import mcjty.rftoolsdim.dimensions.dimlets.types.LiquidDimletType;
import mcjty.rftoolsdim.dimensions.dimlets.types.MaterialDimletType;
import mcjty.rftoolsdim.dimensions.dimlets.types.MobDimletType;
import mcjty.rftoolsdim.dimensions.dimlets.types.PatreonDimletType;
import mcjty.rftoolsdim.dimensions.dimlets.types.SkyDimletType;
import mcjty.rftoolsdim.dimensions.dimlets.types.SpecialDimletType;
import mcjty.rftoolsdim.dimensions.dimlets.types.StructureDimletType;
import mcjty.rftoolsdim.dimensions.dimlets.types.TerrainDimletType;
import mcjty.rftoolsdim.dimensions.dimlets.types.TimeDimletType;
import mcjty.rftoolsdim.dimensions.dimlets.types.WeatherDimletType;

public enum DimletType {
    DIMLET_BIOME(new BiomeDimletType()),
    DIMLET_LIQUID(new LiquidDimletType()),
    DIMLET_MATERIAL(new MaterialDimletType()),
    DIMLET_MOB(new MobDimletType()),
    DIMLET_SKY(new SkyDimletType()),
    DIMLET_STRUCTURE(new StructureDimletType()),
    DIMLET_TERRAIN(new TerrainDimletType()),
    DIMLET_FEATURE(new FeatureDimletType()),
    DIMLET_TIME(new TimeDimletType()),
    DIMLET_DIGIT(new DigitDimletType()),
    DIMLET_EFFECT(new EffectDimletType()),
    DIMLET_SPECIAL(new SpecialDimletType()),
    DIMLET_CONTROLLER(new ControllerDimletType()),
    DIMLET_WEATHER(new WeatherDimletType()),
    DIMLET_PATREON(new PatreonDimletType());

    public final IDimletType dimletType;
    private static final Map<String, DimletType> typeByName;
    private static final Map<String, DimletType> typeByOpcode;

    private DimletType(IDimletType dimletType) {
        this.dimletType = dimletType;
    }

    public static DimletType getTypeByName(String name) {
        return typeByName.get(name.toLowerCase());
    }

    public static DimletType getTypeByOpcode(String opcode) {
        return typeByOpcode.get(opcode);
    }

    static {
        typeByName = new HashMap<String, DimletType>();
        typeByOpcode = new HashMap<String, DimletType>();
        for (DimletType type : DimletType.values()) {
            typeByName.put(type.dimletType.getName().toLowerCase(), type);
            typeByOpcode.put(type.dimletType.getOpcode(), type);
        }
    }
}

