/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.storage.data.IAEItemStack;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MeaningfulItemIterator<T extends IAEItemStack>
implements Iterator<T> {
    private final Iterator<T> parent;
    private T next;

    public MeaningfulItemIterator(Collection<T> collection) {
        this.parent = collection.iterator();
        this.next = this.seekNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public T next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        T result = this.next;
        this.next = this.seekNext();
        return result;
    }

    private T seekNext() {
        while (this.parent.hasNext()) {
            IAEItemStack item = (IAEItemStack)this.parent.next();
            if (item.isMeaningful()) {
                return (T)item;
            }
            this.parent.remove();
        }
        return null;
    }
}

