/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.api.config.FuzzyMode;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.ItemHandlerIterator;
import appeng.util.inv.ItemSlot;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class AdaptorItemHandler
extends InventoryAdaptor {
    protected final IItemHandler itemHandler;

    public AdaptorItemHandler(IItemHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    @Override
    public boolean hasSlots() {
        return this.itemHandler.getSlots() > 0;
    }

    @Override
    public ItemStack removeItems(int amount, ItemStack filter, IInventoryDestination destination) {
        int slots = this.itemHandler.getSlots();
        ItemStack rv = ItemStack.field_190927_a;
        for (int slot = 0; slot < slots && amount > 0; ++slot) {
            ItemStack extracted;
            ItemStack is = this.itemHandler.getStackInSlot(slot);
            if (is.func_190926_b() || !filter.func_190926_b() && !Platform.itemComparisons().isSameItem(is, filter)) continue;
            if (destination != null) {
                if (!destination.canInsert(is)) break;
                extracted = this.itemHandler.extractItem(slot, amount, true);
                if (extracted.func_190926_b()) continue;
            }
            if ((extracted = this.itemHandler.extractItem(slot, amount, false)).func_190926_b()) continue;
            if (rv.func_190926_b()) {
                rv = extracted;
                filter = extracted;
                amount -= extracted.func_190916_E();
                continue;
            }
            rv.func_190917_f(extracted.func_190916_E());
            amount -= extracted.func_190916_E();
        }
        return rv;
    }

    @Override
    public ItemStack simulateRemove(int amount, ItemStack filter, IInventoryDestination destination) {
        int slots = this.itemHandler.getSlots();
        ItemStack rv = ItemStack.field_190927_a;
        for (int slot = 0; slot < slots && amount > 0; ++slot) {
            ItemStack is = this.itemHandler.getStackInSlot(slot);
            if (is.func_190926_b() || !filter.func_190926_b() && !Platform.itemComparisons().isSameItem(is, filter)) continue;
            if (destination != null && !destination.canInsert(is)) break;
            ItemStack extracted = this.itemHandler.extractItem(slot, amount, true);
            if (extracted.func_190926_b()) continue;
            if (rv.func_190926_b()) {
                rv = extracted.func_77946_l();
                filter = extracted;
                amount -= extracted.func_190916_E();
                continue;
            }
            rv.func_190917_f(extracted.func_190916_E());
            amount -= extracted.func_190916_E();
        }
        return rv;
    }

    @Override
    public ItemStack removeSimilarItems(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        int slots = this.itemHandler.getSlots();
        ItemStack extracted = ItemStack.field_190927_a;
        for (int slot = 0; slot < slots && extracted.func_190926_b(); ++slot) {
            ItemStack simulated;
            ItemStack is = this.itemHandler.getStackInSlot(slot);
            if (is.func_190926_b() || !filter.func_190926_b() && !Platform.itemComparisons().isFuzzyEqualItem(is, filter, fuzzyMode) || destination != null && (!destination.canInsert(is) || (simulated = this.itemHandler.extractItem(slot, amount, true)).func_190926_b()) || (extracted = this.itemHandler.extractItem(slot, amount, false)).func_190926_b()) continue;
            return extracted;
        }
        return extracted;
    }

    @Override
    public ItemStack simulateSimilarRemove(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        int slots = this.itemHandler.getSlots();
        ItemStack extracted = ItemStack.field_190927_a;
        for (int slot = 0; slot < slots && extracted.func_190926_b(); ++slot) {
            ItemStack is = this.itemHandler.getStackInSlot(slot);
            if (is.func_190926_b() || !filter.func_190926_b() && !Platform.itemComparisons().isFuzzyEqualItem(is, filter, fuzzyMode) || destination != null && !destination.canInsert(is) || (extracted = this.itemHandler.extractItem(slot, amount, true)).func_190926_b()) continue;
            return extracted;
        }
        return extracted;
    }

    @Override
    public ItemStack addItems(ItemStack toBeAdded) {
        return this.addItems(toBeAdded, false);
    }

    @Override
    public ItemStack simulateAdd(ItemStack toBeSimulated) {
        return this.addItems(toBeSimulated, true);
    }

    protected ItemStack addItems(ItemStack itemsToAdd, boolean simulate) {
        if (itemsToAdd.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        for (int slot = 0; slot < this.itemHandler.getSlots(); ++slot) {
            if (!simulate) {
                itemsToAdd = itemsToAdd.func_77946_l();
            }
            if (!(itemsToAdd = this.itemHandler.insertItem(slot, itemsToAdd, simulate)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return itemsToAdd;
    }

    @Override
    public boolean containsItems() {
        int slots = this.itemHandler.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            if (this.itemHandler.getStackInSlot(slot).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<ItemSlot> iterator() {
        return new ItemHandlerIterator(this.itemHandler);
    }
}

