/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.StorageFilter;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import appeng.fluids.util.AEFluidStack;
import appeng.me.storage.ITickingMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class MEMonitorIFluidHandler
implements IMEMonitor<IAEFluidStack>,
ITickingMonitor {
    private final IFluidHandler handler;
    private IItemList<IAEFluidStack> cache = AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class).createList();
    private final HashMap<IMEMonitorHandlerReceiver<IAEFluidStack>, Object> listeners = new HashMap();
    private IActionSource mySource;
    private StorageFilter mode = StorageFilter.EXTRACTABLE_ONLY;

    public MEMonitorIFluidHandler(IFluidHandler handler) {
        this.handler = handler;
    }

    @Override
    public void addListener(IMEMonitorHandlerReceiver<IAEFluidStack> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    @Override
    public void removeListener(IMEMonitorHandlerReceiver<IAEFluidStack> l) {
        this.listeners.remove(l);
    }

    @Override
    public IAEFluidStack injectItems(IAEFluidStack input, Actionable type, IActionSource src) {
        int filled = this.handler.fill(input.getFluidStack(), type == Actionable.MODULATE);
        if (filled == 0) {
            return input.copy();
        }
        if ((long)filled == input.getStackSize()) {
            return null;
        }
        IAEFluidStack o = input.copy();
        o.setStackSize(input.getStackSize() - (long)filled);
        if (type == Actionable.MODULATE) {
            IAEFluidStack added = o.copy();
            this.cache.add(added);
            this.postDifference(Collections.singletonList(added));
            this.onTick();
        }
        return o;
    }

    @Override
    public IAEFluidStack extractItems(IAEFluidStack request, Actionable type, IActionSource src) {
        IAEFluidStack cachedStack;
        FluidStack removed = this.handler.drain(request.getFluidStack(), type == Actionable.MODULATE);
        if (removed == null || removed.amount == 0) {
            return null;
        }
        IAEFluidStack o = request.copy();
        o.setStackSize(removed.amount);
        if (type == Actionable.MODULATE && (cachedStack = this.cache.findPrecise(request)) != null) {
            cachedStack.decStackSize(o.getStackSize());
            this.postDifference(Collections.singletonList((IAEFluidStack)o.copy().setStackSize(-o.getStackSize())));
        }
        return o;
    }

    @Override
    public IStorageChannel getChannel() {
        return AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class);
    }

    @Override
    public TickRateModulation onTick() {
        boolean changed = false;
        ArrayList<IAEFluidStack> changes = new ArrayList<IAEFluidStack>();
        IFluidTankProperties[] tankProperties = this.handler.getTankProperties();
        IItemList<AEFluidStack> currentlyOnStorage = AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class).createList();
        for (IFluidTankProperties tankProperty : tankProperties) {
            if (this.mode == StorageFilter.EXTRACTABLE_ONLY && this.handler.drain(1, false) == null) continue;
            currentlyOnStorage.add(AEFluidStack.fromFluidStack(tankProperty.getContents()));
        }
        for (IAEFluidStack iAEFluidStack : this.cache) {
            iAEFluidStack.setStackSize(-iAEFluidStack.getStackSize());
        }
        for (IAEFluidStack iAEFluidStack : currentlyOnStorage) {
            this.cache.add(iAEFluidStack);
        }
        for (IAEFluidStack iAEFluidStack : this.cache) {
            if (iAEFluidStack.getStackSize() == 0L) continue;
            changes.add(iAEFluidStack);
        }
        this.cache = currentlyOnStorage;
        if (!changes.isEmpty()) {
            this.postDifference(changes);
            changed = true;
        }
        return changed ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
    }

    private void postDifference(Iterable<IAEFluidStack> a) {
        if (a != null) {
            Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEFluidStack>, Object>> i = this.listeners.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<IMEMonitorHandlerReceiver<IAEFluidStack>, Object> l = i.next();
                IMEMonitorHandlerReceiver<IAEFluidStack> key = l.getKey();
                if (key.isValid(l.getValue())) {
                    key.postChange(this, a, this.getActionSource());
                    continue;
                }
                i.remove();
            }
        }
    }

    @Override
    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public boolean isPrioritized(IAEFluidStack input) {
        return false;
    }

    @Override
    public boolean canAccept(IAEFluidStack input) {
        return true;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public int getSlot() {
        return 0;
    }

    @Override
    public boolean validForPass(int i) {
        return true;
    }

    @Override
    public IItemList<IAEFluidStack> getAvailableItems(IItemList out) {
        for (IAEFluidStack fs : this.cache) {
            out.addStorage(fs);
        }
        return out;
    }

    @Override
    public IItemList<IAEFluidStack> getStorageList() {
        return this.cache;
    }

    private StorageFilter getMode() {
        return this.mode;
    }

    @Override
    public void setMode(StorageFilter mode) {
        this.mode = mode;
    }

    private IActionSource getActionSource() {
        return this.mySource;
    }

    @Override
    public void setActionSource(IActionSource mySource) {
        this.mySource = mySource;
    }
}

