/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.IncludeExclude;
import appeng.api.config.StorageFilter;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.storage.MEPassThrough;
import appeng.util.prioritylist.DefaultPriorityList;
import appeng.util.prioritylist.IPartitionList;

public class MEInventoryHandler<T extends IAEStack<T>>
implements IMEInventoryHandler<T> {
    private final IMEInventoryHandler<T> internal;
    private int myPriority;
    private IncludeExclude myWhitelist;
    private AccessRestriction myAccess;
    private StorageFilter storageFilter;
    private IPartitionList<T> myPartitionList;
    private AccessRestriction cachedAccessRestriction;
    private boolean hasReadAccess;
    private boolean hasWriteAccess;
    private boolean isSticky;
    private boolean gettingAvailableContent;

    public MEInventoryHandler(IMEInventory<T> i, IStorageChannel<T> channel) {
        this.internal = i instanceof IMEInventoryHandler ? (IMEInventoryHandler)i : new MEPassThrough<T>(i, channel);
        this.myPriority = 0;
        this.myWhitelist = IncludeExclude.WHITELIST;
        this.setBaseAccess(AccessRestriction.READ_WRITE);
        this.myPartitionList = new DefaultPriorityList();
    }

    IncludeExclude getWhitelist() {
        return this.myWhitelist;
    }

    public void setWhitelist(IncludeExclude myWhitelist) {
        this.myWhitelist = myWhitelist;
    }

    public AccessRestriction getBaseAccess() {
        return this.myAccess;
    }

    public void setBaseAccess(AccessRestriction myAccess) {
        this.myAccess = myAccess;
        this.cachedAccessRestriction = this.myAccess.restrictPermissions(this.internal.getAccess());
        this.hasReadAccess = this.cachedAccessRestriction.hasPermission(AccessRestriction.READ);
        this.hasWriteAccess = this.cachedAccessRestriction.hasPermission(AccessRestriction.WRITE);
    }

    public IPartitionList<T> getPartitionList() {
        return this.myPartitionList;
    }

    public void setPartitionList(IPartitionList<T> myPartitionList) {
        this.myPartitionList = myPartitionList;
    }

    @Override
    public T injectItems(T input, Actionable type, IActionSource src) {
        if (!this.canAccept(input)) {
            return input;
        }
        return this.internal.injectItems(input, type, src);
    }

    @Override
    public T extractItems(T request, Actionable type, IActionSource src) {
        if (!this.canExtract(request)) {
            return null;
        }
        return this.internal.extractItems(request, type, src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IItemList<T> getAvailableItems(IItemList<T> out) {
        block6: {
            if (this.gettingAvailableContent || !this.hasReadAccess) {
                return out;
            }
            this.gettingAvailableContent = true;
            try {
                if (this.storageFilter == StorageFilter.EXTRACTABLE_ONLY) {
                    IItemList<T> stackList = this.internal.getAvailableItems(this.getChannel().createList());
                    for (IAEStack t : stackList) {
                        if (!this.shouldItemBeAvailable(t)) continue;
                        out.add(t);
                    }
                    break block6;
                }
                IItemList<T> iItemList = this.internal.getAvailableItems(out);
                return iItemList;
            }
            finally {
                this.gettingAvailableContent = false;
            }
        }
        return out;
    }

    @Override
    public IStorageChannel<T> getChannel() {
        return this.internal.getChannel();
    }

    @Override
    public AccessRestriction getAccess() {
        return this.cachedAccessRestriction;
    }

    @Override
    public boolean isPrioritized(T input) {
        if (this.myWhitelist == IncludeExclude.WHITELIST) {
            return this.myPartitionList.isListed(input) || this.internal.isPrioritized(input);
        }
        return false;
    }

    @Override
    public boolean canAccept(T input) {
        if (!this.hasWriteAccess) {
            return false;
        }
        if (!this.passesBlackOrWhitelist(input)) {
            return false;
        }
        return this.internal.canAccept(input);
    }

    @Override
    public int getPriority() {
        return this.myPriority;
    }

    public void setPriority(int myPriority) {
        this.myPriority = myPriority;
    }

    @Override
    public int getSlot() {
        return this.internal.getSlot();
    }

    @Override
    public boolean validForPass(int i) {
        return true;
    }

    public IMEInventory<T> getInternal() {
        return this.internal;
    }

    @Override
    public boolean isSticky() {
        return this.isSticky;
    }

    public void setSticky(boolean isSticky) {
        this.isSticky = isSticky;
    }

    protected boolean canExtract(T request) {
        return this.hasReadAccess;
    }

    private boolean shouldItemBeAvailable(T t) {
        return this.hasReadAccess && this.passesBlackOrWhitelist(t);
    }

    public boolean passesBlackOrWhitelist(T input) {
        boolean bl;
        if (this.myPartitionList.isEmpty()) {
            return true;
        }
        switch (this.myWhitelist) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case WHITELIST: {
                bl = this.myPartitionList.isListed(input);
                break;
            }
            case BLACKLIST: {
                bl = !this.myPartitionList.isListed(input);
            }
        }
        return bl;
    }

    public StorageFilter getStorageFilter() {
        return this.storageFilter;
    }

    public void setStorageFilter(StorageFilter storageFilter) {
        this.storageFilter = storageFilter;
    }
}

