/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.client.gui;

import appeng.api.config.Settings;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.client.gui.AEBaseMEGui;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.gui.widgets.MEGuiTextField;
import appeng.client.me.FluidRepo;
import appeng.client.me.InternalFluidSlotME;
import appeng.client.me.SlotFluidME;
import appeng.core.AELog;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.fluids.container.ContainerFluidTerminal;
import appeng.fluids.container.slots.IMEFluidSlot;
import appeng.helpers.InventoryAction;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.lwjgl.input.Mouse;

public class GuiFluidTerminal
extends AEBaseMEGui
implements ISortSource,
IConfigManagerHost {
    private final List<SlotFluidME> meFluidSlots = new LinkedList<SlotFluidME>();
    private final FluidRepo repo;
    private final IConfigManager configSrc;
    private final ContainerFluidTerminal container;
    private final int offsetX = 9;
    private final int rows = 6;
    private final int perRow = 9;
    protected ITerminalHost terminal;
    private MEGuiTextField searchField;
    private GuiImgButton sortByBox;
    private GuiImgButton sortDirBox;

    public GuiFluidTerminal(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        this(inventoryPlayer, te, new ContainerFluidTerminal(inventoryPlayer, te));
    }

    public GuiFluidTerminal(InventoryPlayer inventoryPlayer, ITerminalHost te, ContainerFluidTerminal c) {
        super(c);
        this.terminal = te;
        this.field_146999_f = 185;
        this.field_147000_g = 222;
        GuiScrollbar scrollbar = new GuiScrollbar();
        this.setScrollBar(scrollbar);
        this.repo = new FluidRepo(scrollbar, this);
        this.configSrc = ((IConfigurableObject)this.field_147002_h).getConfigManager();
        this.container = (ContainerFluidTerminal)this.field_147002_h;
        this.container.setGui(this);
    }

    @Override
    public void func_73866_w_() {
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        Objects.requireNonNull(this);
        this.searchField = new MEGuiTextField(this.field_146289_q, this.field_147003_i + Math.max(80, 9), this.field_147009_r + 4, 90, 12);
        this.searchField.func_146185_a(false);
        this.searchField.func_146203_f(25);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.setSelectionColor(-6684775);
        this.searchField.func_146189_e(true);
        int offset = this.field_147009_r;
        this.sortByBox = new GuiImgButton(this.field_147003_i - 18, offset, Settings.SORT_BY, this.configSrc.getSetting(Settings.SORT_BY));
        this.field_146292_n.add(this.sortByBox);
        this.sortDirBox = new GuiImgButton(this.field_147003_i - 18, offset += 20, Settings.SORT_DIRECTION, this.configSrc.getSetting(Settings.SORT_DIRECTION));
        this.field_146292_n.add(this.sortDirBox);
        block0: for (int y = 0; y < this.rows; ++y) {
            int x = 0;
            while (true) {
                Objects.requireNonNull(this);
                if (x >= 9) continue block0;
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                SlotFluidME slot = new SlotFluidME(new InternalFluidSlotME(this.repo, x + y * 9, 9 + x * 18, 18 + y * 18));
                this.getMeFluidSlots().add(slot);
                this.field_147002_h.field_75151_b.add(slot);
                ++x;
            }
        }
        this.setScrollBar();
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName("Fluid Terminal"), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), 8, this.field_147000_g - 96 + 3, 0x404040);
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture(this.getBackground());
        int x_width = 197;
        this.func_73729_b(offsetX, offsetY, 0, 0, 197, 18);
        for (int x = 0; x < 6; ++x) {
            this.func_73729_b(offsetX, offsetY + 18 + x * 18, 0, 18, 197, 18);
        }
        this.func_73729_b(offsetX, offsetY + 16 + 108, 0, 70, 197, 176);
        if (this.searchField != null) {
            this.searchField.func_146194_f();
        }
    }

    public void func_73876_c() {
        this.repo.setPower(this.container.isPowered());
        super.func_73876_c();
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        IMEFluidSlot fluidSlot;
        Slot slot = this.getSlot(mouseX, mouseY);
        if (slot != null && slot instanceof IMEFluidSlot && slot.func_111238_b() && (fluidSlot = (IMEFluidSlot)slot).getAEFluidStack() != null && fluidSlot.shouldRenderAsFluid()) {
            IAEFluidStack fluidStack = fluidSlot.getAEFluidStack();
            String formattedAmount = NumberFormat.getNumberInstance(Locale.US).format((double)fluidStack.getStackSize() / 1000.0) + " B";
            String modName = "" + TextFormatting.BLUE + TextFormatting.ITALIC + ((ModContainer)Loader.instance().getIndexedModList().get(Platform.getModId(fluidStack))).getName();
            ArrayList<String> list = new ArrayList<String>();
            list.add(fluidStack.getFluidStack().getLocalizedName());
            list.add(formattedAmount);
            list.add(modName);
            this.func_146283_a(list, mouseX, mouseY);
            return;
        }
        super.func_191948_b(mouseX, mouseY);
    }

    protected void func_146284_a(GuiButton btn) throws IOException {
        if (btn instanceof GuiImgButton) {
            boolean backwards = Mouse.isButtonDown((int)1);
            GuiImgButton iBtn = (GuiImgButton)btn;
            if (iBtn.getSetting() != Settings.ACTIONS) {
                Enum cv = iBtn.getCurrentValue();
                Enum next = Platform.rotateEnum(cv, backwards, iBtn.getSetting().getPossibleValues());
                try {
                    NetworkHandler.instance().sendToServer(new PacketValueConfig(iBtn.getSetting().name(), next.name()));
                }
                catch (IOException e) {
                    AELog.debug(e);
                }
                iBtn.set(next);
            }
        }
    }

    @Override
    protected void func_184098_a(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        if (slot instanceof SlotFluidME) {
            SlotFluidME meSlot = (SlotFluidME)slot;
            if (clickType == ClickType.PICKUP) {
                if (mouseButton == 0 && meSlot.func_75216_d()) {
                    this.container.setTargetStack(meSlot.getAEFluidStack());
                    AELog.debug("mouse0 GUI STACK SIZE %s", meSlot.getAEFluidStack().getStackSize());
                    NetworkHandler.instance().sendToServer(new PacketInventoryAction(InventoryAction.FILL_ITEM, slot.field_75222_d, 0L));
                } else {
                    this.container.setTargetStack(meSlot.getAEFluidStack());
                    if (meSlot.getAEFluidStack() != null) {
                        AELog.debug("mouse1 GUI STACK SIZE %s", meSlot.getAEFluidStack().getStackSize());
                    }
                    NetworkHandler.instance().sendToServer(new PacketInventoryAction(InventoryAction.EMPTY_ITEM, slot.field_75222_d, 0L));
                }
            }
            return;
        }
        super.func_184098_a(slot, slotIdx, mouseButton, clickType);
    }

    protected void func_73869_a(char character, int key) throws IOException {
        if (!this.func_146983_a(key)) {
            if (character == ' ' && this.searchField.func_146179_b().isEmpty()) {
                return;
            }
            if (this.searchField.func_146201_a(character, key)) {
                this.repo.setSearchString(this.searchField.func_146179_b());
                this.repo.updateView();
                this.setScrollBar();
            } else {
                super.func_73869_a(character, key);
            }
        }
    }

    @Override
    protected void func_73864_a(int xCoord, int yCoord, int btn) throws IOException {
        this.searchField.func_146192_a(xCoord, yCoord, btn);
        if (btn == 1 && this.searchField.isMouseIn(xCoord, yCoord)) {
            this.searchField.func_146180_a("");
            this.repo.setSearchString("");
            this.repo.updateView();
            this.setScrollBar();
        }
        super.func_73864_a(xCoord, yCoord, btn);
    }

    public void postUpdate(List<IAEFluidStack> list) {
        for (IAEFluidStack is : list) {
            this.repo.postUpdate(is);
        }
        this.repo.updateView();
        this.setScrollBar();
    }

    private void setScrollBar() {
        this.getScrollBar().setTop(18).setLeft(175).setHeight(this.rows * 18 - 2);
        GuiScrollbar guiScrollbar = this.getScrollBar();
        int n = this.repo.size();
        Objects.requireNonNull(this);
        int n2 = n + 9 - 1;
        Objects.requireNonNull(this);
        guiScrollbar.setRange(0, n2 / 9 - this.rows, Math.max(1, this.rows / 6));
    }

    @Override
    public Enum getSortBy() {
        return this.configSrc.getSetting(Settings.SORT_BY);
    }

    @Override
    public Enum getSortDir() {
        return this.configSrc.getSetting(Settings.SORT_DIRECTION);
    }

    @Override
    public Enum getSortDisplay() {
        return this.configSrc.getSetting(Settings.VIEW_MODE);
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.sortByBox != null) {
            this.sortByBox.set(this.configSrc.getSetting(Settings.SORT_BY));
        }
        if (this.sortDirBox != null) {
            this.sortDirBox.set(this.configSrc.getSetting(Settings.SORT_DIRECTION));
        }
        this.repo.updateView();
    }

    protected List<SlotFluidME> getMeFluidSlots() {
        return this.meFluidSlots;
    }

    @Override
    protected boolean isPowered() {
        return this.repo.hasPower();
    }

    protected String getBackground() {
        return "guis/terminal.png";
    }
}

