/*
 * Decompiled with CFR 0.152.
 */
package appeng.decorative.slab;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockSlabCommon
extends BlockSlab {
    static final PropertyEnum<Variant> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variant.class);

    private BlockSlabCommon(Block block) {
        super(block.func_149688_o(block.func_176223_P()));
        this.func_149711_c(block.func_176195_g(block.func_176223_P(), null, null));
        this.func_149752_b(block.func_149638_a(null) * 5.0f / 3.0f);
        IBlockState iblockstate = this.field_176227_L.func_177621_b();
        if (!this.func_176552_j()) {
            iblockstate = iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        }
        this.func_180632_j(iblockstate.func_177226_a(VARIANT, (Comparable)((Object)Variant.DEFAULT)));
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.field_149783_u = true;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Variant.DEFAULT));
        if (!this.func_176552_j()) {
            iblockstate = iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        }
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (!this.func_176552_j() && state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return this.func_176552_j() ? new BlockStateContainer((Block)this, new IProperty[]{VARIANT}) : new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, VARIANT});
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, 0);
    }

    public String func_150002_b(int meta) {
        return this.func_149739_a();
    }

    public IProperty<?> func_176551_l() {
        return VARIANT;
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return Variant.DEFAULT;
    }

    public static enum Variant implements IStringSerializable
    {
        DEFAULT;


        public String func_176610_l() {
            return "default";
        }
    }

    public static class Half
    extends BlockSlabCommon {
        public Half(Block block) {
            super(block);
        }

        public boolean func_176552_j() {
            return false;
        }

        public boolean doesSideBlockChestOpening(@Nonnull IBlockState blockState, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
            return false;
        }
    }

    public static class Double
    extends BlockSlabCommon {
        private final Block halfSlabBlock;

        public Double(Block halfSlabBlock, Block block) {
            super(block);
            this.halfSlabBlock = halfSlabBlock;
        }

        public boolean func_176552_j() {
            return true;
        }

        @Override
        @Nullable
        public Item func_180660_a(IBlockState state, Random rand, int fortune) {
            return Item.func_150898_a((Block)this.halfSlabBlock);
        }

        @Override
        public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
            return new ItemStack(this.halfSlabBlock, 1, 0);
        }
    }
}

