/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.tile.AEBaseTile;
import com.google.common.math.IntMath;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEnergyGenerator
extends AEBaseTile
implements ITickable,
IEnergyStorage {
    private static final int BASE_ENERGY = 8;

    public void func_73660_a() {
        int tier = 1;
        EnumSet<EnumFacing> validEnergyReceivers = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing facing : EnumFacing.values()) {
            TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing));
            if (te instanceof TileEnergyGenerator) {
                ++tier;
            }
            if (te == null || !te.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())) continue;
            validEnergyReceivers.add(facing);
        }
        int energyToInsert = IntMath.pow((int)8, (int)tier);
        for (EnumFacing facing : validEnergyReceivers) {
            TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing));
            IEnergyStorage cap = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d());
            if (!cap.canReceive()) continue;
            cap.receiveEnergy(energyToInsert, false);
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return maxExtract;
    }

    public int getEnergyStored() {
        return Integer.MAX_VALUE;
    }

    public int getMaxEnergyStored() {
        return Integer.MAX_VALUE;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }
}

