/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.config.CondenserOutput;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.config.YesNo;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.core.AELog;
import appeng.core.features.AEFeature;
import appeng.core.settings.TickRates;
import appeng.items.materials.MaterialType;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class AEConfig
extends Configuration
implements IConfigurableObject,
IConfigManagerHost {
    public static final String VERSION = "v0.56.4";
    public static final String CHANNEL = "stable";
    public static final String PACKET_CHANNEL = "AE";
    public static final double TUNNEL_POWER_LOSS = 0.05;
    private static final String[] ORES_VANILLA = new String[]{"Obsidian", "Ender", "EnderPearl", "Coal", "Iron", "Gold", "Charcoal", "NetherQuartz"};
    private static final String[] ORES_AE = new String[]{"CertusQuartz", "Wheat", "Fluix"};
    private static final String[] ORES_COMMON = new String[]{"Copper", "Tin", "Silver", "Lead", "Bronze"};
    private static final String[] ORES_MISC = new String[]{"Brass", "Platinum", "Nickel", "Invar", "Aluminium", "Electrum", "Osmium", "Zinc"};
    private static final double DEFAULT_IC2_EXCHANGE = 2.0;
    private static final double DEFAULT_GTEU_EXCHANGE = 2.0;
    private static final double DEFAULT_RF_EXCHANGE = 0.5;
    private static AEConfig instance;
    private final IConfigManager settings = new ConfigManager(this);
    private final EnumSet<AEFeature> featureFlags = EnumSet.noneOf(AEFeature.class);
    private final File configFile;
    private final int[] craftByStacks = new int[]{1, 10, 100, 1000};
    private final int[] priorityByStacks = new int[]{1, 10, 100, 1000};
    private final int[] levelByStacks = new int[]{1, 10, 100, 1000};
    private final int[] levelByMillibuckets = new int[]{10, 100, 1000, 10000};
    private final Set<String> grinderBlackList;
    private final int chargedChange = 4;
    private final double wirelessHighWirelessCount = 64.0;
    private String[] nonBlockingItems = new String[]{"[gregtech|actuallyadditions]", "gregtech:circuit.integrated", "gregtech:shape.mold.plate", "gregtech:shape.mold.gear", "gregtech:shape.mold.credit", "gregtech:shape.mold.bottle", "gregtech:shape.mold.ingot", "gregtech:shape.mold.ball", "gregtech:shape.mold.block", "gregtech:shape.mold.nugget", "gregtech:shape.mold.cylinder", "gregtech:shape.mold.anvil", "gregtech:shape.mold.name", "gregtech:shape.mold.gear.small", "gregtech:shape.mold.rotor", "gregtech:shape.extruder.plate", "gregtech:shape.extruder.rod", "gregtech:shape.extruder.bolt", "gregtech:shape.extruder.ring", "gregtech:shape.extruder.cell", "gregtech:shape.extruder.ingot", "gregtech:shape.extruder.wire", "gregtech:shape.extruder.pipe.tiny", "gregtech:shape.extruder.pipe.small", "gregtech:shape.extruder.pipe.medium", "gregtech:shape.extruder.pipe.normal", "gregtech:shape.extruder.pipe.large", "gregtech:shape.extruder.pipe.huge", "gregtech:shape.extruder.block", "gregtech:shape.extruder.sword", "gregtech:shape.extruder.pickaxe", "gregtech:shape.extruder.shovel", "gregtech:shape.extruder.axe", "gregtech:shape.extruder.hoe", "gregtech:shape.extruder.hammer", "gregtech:shape.extruder.file", "gregtech:shape.extruder.saw", "gregtech:shape.extruder.gear", "gregtech:shape.extruder.bottle", "gregtech:shape.extruder.foil", "gregtech:shape.extruder.gear_small", "gregtech:shape.extruder.rod_long", "gregtech:shape.extruder.rotor", "gregtech:glass_lens.white", "gregtech:glass_lens.orange", "gregtech:glass_lens.magenta", "gregtech:glass_lens.light_blue", "gregtech:glass_lens.yellow", "gregtech:glass_lens.lime", "gregtech:glass_lens.pink", "gregtech:glass_lens.gray", "gregtech:glass_lens.light_gray", "gregtech:glass_lens.cyan", "gregtech:glass_lens.purple", "gregtech:glass_lens.blue", "gregtech:glass_lens.brown", "gregtech:glass_lens.green", "gregtech:glass_lens.red", "gregtech:glass_lens.black", "contenttweaker:smallgearextrudershape", "contenttweaker:creativeportabletankmold", "ore:lensAlmandine", "ore:lensBlueTopaz", "ore:lensDiamond", "ore:lensEmerald", "ore:lensGreenSapphire", "ore:lensRutile", "ore:lensRuby", "ore:lensSapphire", "ore:lensTopaz", "ore:lensJasper", "ore:lensGlass", "ore:lensOlivine", "ore:lensOpal", "ore:lensAmethyst", "ore:lensLapis", "ore:lensEnderPearl", "ore:lensEnderEye", "ore:lensGarnetRed", "ore:lensGarnetYellow", "ore:lensVinteum", "ore:lensNetherStar"};
    private boolean updatable = false;
    private boolean removeCrashingItemsOnLoad = false;
    private int formationPlaneEntityLimit = 128;
    private boolean enableEffects = true;
    private boolean useLargeFonts = false;
    private boolean useColoredCraftingStatus;
    private boolean disableColoredCableRecipesInJEI = true;
    private int craftingCalculationTimePerTick = 5;
    private PowerUnits selectedPowerUnit = PowerUnits.AE;
    private boolean showCraftableTooltip = true;
    private boolean showPlacementPreview = true;
    private int storageProviderID = -1;
    private int storageDimensionID = -1;
    private double spatialPowerExponent = 1.35;
    private double spatialPowerMultiplier = 1250.0;
    private String[] grinderOres = (String[])Stream.of(ORES_VANILLA, ORES_AE, ORES_COMMON, ORES_MISC).flatMap(Stream::of).toArray(String[]::new);
    private double oreDoublePercentage = 90.0;
    private int wirelessTerminalBattery = 1600000;
    private int entropyManipulatorBattery = 200000;
    private int matterCannonBattery = 200000;
    private int portableCellBattery = 20000;
    private int colorApplicatorBattery = 20000;
    private int chargedStaffBattery = 8000;
    private float spawnChargedChance = 0.92f;
    private int quartzOresPerCluster = 4;
    private int quartzOresClusterAmount = 15;
    private int minMeteoriteDistance = 707;
    private int minMeteoriteDistanceSq = this.minMeteoriteDistance * this.minMeteoriteDistance;
    private double meteoriteClusterChance = 0.1;
    private int meteoriteMaximumSpawnHeight = 180;
    private int[] meteoriteDimensionWhitelist = new int[]{0};
    private double wirelessBaseCost = 8.0;
    private double wirelessCostMultiplier = 1.0;
    private double wirelessTerminalDrainMultiplier = 1.0;
    private double wirelessBaseRange = 16.0;
    private double wirelessBoosterRangeMultiplier = 1.0;
    private double wirelessBoosterExp = 1.5;
    private boolean enableCraftingSubstitutes = false;
    private int maxControllerSizeX = 7;
    private int maxControllerSizeY = 7;
    private int maxControllerSizeZ = 7;
    private int normalChannelCapacity = 8;
    private int denseChannelCapacity = 32;

    private AEConfig(File configFile) {
        super(configFile);
        List<String> version;
        this.configFile = configFile;
        MinecraftForge.EVENT_BUS.register((Object)this);
        PowerUnits.EU.conversionRatio = this.get("PowerRatios", "IC2", 2.0).getDouble(2.0);
        PowerUnits.RF.conversionRatio = this.get("PowerRatios", "ForgeEnergy", 0.5).getDouble(0.5);
        PowerUnits.GTEU.conversionRatio = this.get("PowerRatios", "GTEU", 2.0).getDouble(2.0);
        double usageEffective = this.get("PowerRatios", "UsageMultiplier", 1.0).getDouble(1.0);
        PowerMultiplier.CONFIG.multiplier = Math.max(0.01, usageEffective);
        CondenserOutput.MATTER_BALLS.requiredPower = this.get("Condenser", "MatterBalls", 256).getInt(256);
        CondenserOutput.SINGULARITY.requiredPower = this.get("Condenser", "Singularity", 256000).getInt(256000);
        this.removeCrashingItemsOnLoad = this.get("general", "removeCrashingItemsOnLoad", false, "Will auto-remove items that crash when being loaded from storage. This will destroy those items instead of crashing the game!").getBoolean();
        this.normalChannelCapacity = Math.min(this.get("general", "normalChannelCapacity", this.normalChannelCapacity, "Max channel number may not exceed 256").getInt(this.normalChannelCapacity), 256);
        this.denseChannelCapacity = Math.min(this.get("general", "denseChannelCapacity", this.denseChannelCapacity, "Max channel number may not exceed 256").getInt(this.denseChannelCapacity), 256);
        this.setCategoryComment("BlockingMode", "Map of items to not block when blockingmode is enabled.\n[modid]\nmodid:item:metadata(optional,default:0)\nSupports more than one modid, so you can block different things between, for example, gregtech or enderio");
        this.nonBlockingItems = this.get("BlockingMode", "nonBlockingItems", this.nonBlockingItems, "NonBlockingItems").getStringList();
        this.setCategoryComment("GrindStone", "Creates recipe of the following pattern automatically: '1 oreTYPE => 2 dustTYPE' and '(1 ingotTYPE or 1 crystalTYPE or 1 gemTYPE) => 1 dustTYPE'");
        this.grinderOres = this.get("GrindStone", "grinderOres", this.grinderOres, "The list of types to handle. Specify without a prefix like ore or dust.").getStringList();
        this.grinderBlackList = Sets.newHashSet((Object[])this.get("GrindStone", "blacklist", new String[0], "Blacklists the exact oredict name from being handled by any recipe.").getStringList());
        this.oreDoublePercentage = this.get("GrindStone", "oreDoublePercentage", this.oreDoublePercentage, "Chance to actually get an output with stacksize > 1.").getDouble(this.oreDoublePercentage);
        this.settings.registerSetting(Settings.SEARCH_TOOLTIPS, YesNo.YES);
        this.settings.registerSetting(Settings.TERMINAL_STYLE, TerminalStyle.TALL);
        this.settings.registerSetting(Settings.SEARCH_MODE, SearchBoxMode.AUTOSEARCH);
        this.spawnChargedChance = (float)(1.0 - this.get("worldGen", "spawnChargedChance", 1.0 - (double)this.spawnChargedChance).getDouble(1.0 - (double)this.spawnChargedChance));
        this.minMeteoriteDistance = this.get("worldGen", "minMeteoriteDistance", this.minMeteoriteDistance).getInt(this.minMeteoriteDistance);
        this.meteoriteClusterChance = this.get("worldGen", "meteoriteClusterChance", this.meteoriteClusterChance).getDouble(this.meteoriteClusterChance);
        this.meteoriteMaximumSpawnHeight = this.get("worldGen", "meteoriteMaximumSpawnHeight", this.meteoriteMaximumSpawnHeight).getInt(this.meteoriteMaximumSpawnHeight);
        this.meteoriteDimensionWhitelist = this.get("worldGen", "meteoriteDimensionWhitelist", this.meteoriteDimensionWhitelist).getIntList();
        this.quartzOresPerCluster = this.get("worldGen", "quartzOresPerCluster", this.quartzOresPerCluster).getInt(this.quartzOresPerCluster);
        this.quartzOresClusterAmount = this.get("worldGen", "quartzOresClusterAmount", this.quartzOresClusterAmount).getInt(this.quartzOresClusterAmount);
        this.minMeteoriteDistanceSq = this.minMeteoriteDistance * this.minMeteoriteDistance;
        this.addCustomCategoryComment("wireless", "Range= wirelessBaseRange + wirelessBoosterRangeMultiplier * Math.pow( boosters, wirelessBoosterExp )\nPowerDrain= wirelessBaseCost + wirelessCostMultiplier * Math.pow( boosters, 1 + boosters / wirelessHighWirelessCount )");
        this.wirelessBaseCost = this.get("wireless", "wirelessBaseCost", this.wirelessBaseCost).getDouble(this.wirelessBaseCost);
        this.wirelessCostMultiplier = this.get("wireless", "wirelessCostMultiplier", this.wirelessCostMultiplier).getDouble(this.wirelessCostMultiplier);
        this.wirelessBaseRange = this.get("wireless", "wirelessBaseRange", this.wirelessBaseRange).getDouble(this.wirelessBaseRange);
        this.wirelessBoosterRangeMultiplier = this.get("wireless", "wirelessBoosterRangeMultiplier", this.wirelessBoosterRangeMultiplier).getDouble(this.wirelessBoosterRangeMultiplier);
        this.wirelessBoosterExp = this.get("wireless", "wirelessBoosterExp", this.wirelessBoosterExp).getDouble(this.wirelessBoosterExp);
        this.wirelessTerminalDrainMultiplier = this.get("wireless", "wirelessTerminalDrainMultiplier", this.wirelessTerminalDrainMultiplier).getDouble(this.wirelessTerminalDrainMultiplier);
        this.formationPlaneEntityLimit = this.get("automation", "formationPlaneEntityLimit", this.formationPlaneEntityLimit).getInt(this.formationPlaneEntityLimit);
        this.wirelessTerminalBattery = this.get("battery", "wirelessTerminal", this.wirelessTerminalBattery).getInt(this.wirelessTerminalBattery);
        this.chargedStaffBattery = this.get("battery", "chargedStaff", this.chargedStaffBattery).getInt(this.chargedStaffBattery);
        this.entropyManipulatorBattery = this.get("battery", "entropyManipulator", this.entropyManipulatorBattery).getInt(this.entropyManipulatorBattery);
        this.portableCellBattery = this.get("battery", "portableCell", this.portableCellBattery).getInt(this.portableCellBattery);
        this.colorApplicatorBattery = this.get("battery", "colorApplicator", this.colorApplicatorBattery).getInt(this.colorApplicatorBattery);
        this.matterCannonBattery = this.get("battery", "matterCannon", this.matterCannonBattery).getInt(this.matterCannonBattery);
        this.addCustomCategoryComment("autocrafting", "Enable patterns with substitutions on to have their substitutes to be auto craftable.\nThis changes the crafting tree, and can show missing ingredients for the substitute, instead of the patterned item");
        this.enableCraftingSubstitutes = this.get("autocrafting", "EnableAutocraftinSubstitutes", this.enableCraftingSubstitutes).getBoolean(this.enableCraftingSubstitutes);
        this.addCustomCategoryComment("ControllerSize", "Set the max size of a controller in any of the 3 axis.\nEach is between [1, 64)");
        this.maxControllerSizeX = Math.min(Math.max(this.get("ControllerSize", "maxControllerSizeX", this.maxControllerSizeX).getInt(this.maxControllerSizeX), 1), 63);
        this.maxControllerSizeY = Math.min(Math.max(this.get("ControllerSize", "maxControllerSizeY", this.maxControllerSizeY).getInt(this.maxControllerSizeY), 1), 63);
        this.maxControllerSizeZ = Math.min(Math.max(this.get("ControllerSize", "maxControllerSizeZ", this.maxControllerSizeZ).getInt(this.maxControllerSizeZ), 1), 63);
        this.clientSync();
        this.addCustomCategoryComment("features", "Warning: Disabling a feature may disable other features depending on it.");
        for (AEFeature feature : AEFeature.values()) {
            if (feature.isVisible()) {
                Property option = this.get("Features." + feature.category(), feature.key(), feature.isEnabled(), feature.comment());
                if (!option.getBoolean(feature.isEnabled())) continue;
                this.featureFlags.add(feature);
                continue;
            }
            this.featureFlags.add(feature);
        }
        ModContainer imb = (ModContainer)Loader.instance().getIndexedModList().get("ImmibisCore");
        if (imb != null && (version = Arrays.asList("59.0.0", "59.0.1", "59.0.2")).contains(imb.getVersion())) {
            this.featureFlags.remove((Object)AEFeature.ALPHA_PASS);
        }
        try {
            this.selectedPowerUnit = PowerUnits.valueOf(this.get("Client", "PowerUnit", this.selectedPowerUnit.name(), this.getListComment(this.selectedPowerUnit)).getString());
        }
        catch (Throwable t) {
            this.selectedPowerUnit = PowerUnits.AE;
        }
        for (TickRates tr : TickRates.values()) {
            tr.Load(this);
        }
        if (this.isFeatureEnabled(AEFeature.SPATIAL_IO)) {
            this.storageProviderID = this.get("spatialio", "storageProviderID", this.storageProviderID).getInt(this.storageProviderID);
            this.storageDimensionID = this.get("spatialio", "storageDimensionID", this.storageDimensionID).getInt(this.storageDimensionID);
            this.spatialPowerMultiplier = this.get("spatialio", "spatialPowerMultiplier", this.spatialPowerMultiplier).getDouble(this.spatialPowerMultiplier);
            this.spatialPowerExponent = this.get("spatialio", "spatialPowerExponent", this.spatialPowerExponent).getDouble(this.spatialPowerExponent);
        }
        if (this.isFeatureEnabled(AEFeature.CRAFTING_CPU)) {
            this.craftingCalculationTimePerTick = this.get("craftingCPU", "craftingCalculationTimePerTick", this.craftingCalculationTimePerTick).getInt(this.craftingCalculationTimePerTick);
        }
        this.updatable = true;
    }

    public static void init(File configFile) {
        instance = new AEConfig(configFile);
    }

    public static AEConfig instance() {
        return instance;
    }

    private void clientSync() {
        this.disableColoredCableRecipesInJEI = this.get("Client", "disableColoredCableRecipesInJEI", true).getBoolean(true);
        this.enableEffects = this.get("Client", "enableEffects", true).getBoolean(true);
        this.useLargeFonts = this.get("Client", "useTerminalUseLargeFont", false).getBoolean(false);
        this.useColoredCraftingStatus = this.get("Client", "useColoredCraftingStatus", true).getBoolean(true);
        this.showCraftableTooltip = this.get("Client", "showCraftableTooltip", true, "Whether to add \"Craftable\" to item tooltips when they can be crafted automatically.").getBoolean(true);
        this.showPlacementPreview = this.get("Client", "showPlacementPreview", true, "Whether to show a preview of part and facade placement.").getBoolean(true);
        for (int btnNum = 0; btnNum < 4; ++btnNum) {
            Property cmb = this.get("Client", "craftAmtButton" + (btnNum + 1), this.craftByStacks[btnNum]);
            Property pmb = this.get("Client", "priorityAmtButton" + (btnNum + 1), this.priorityByStacks[btnNum]);
            Property lmb = this.get("Client", "levelAmtButton" + (btnNum + 1), this.levelByStacks[btnNum]);
            int buttonCap = (int)(Math.pow(10.0, btnNum + 1) - 1.0);
            this.craftByStacks[btnNum] = Math.abs(cmb.getInt(this.craftByStacks[btnNum]));
            this.priorityByStacks[btnNum] = Math.abs(pmb.getInt(this.priorityByStacks[btnNum]));
            this.levelByStacks[btnNum] = Math.abs(lmb.getInt(this.levelByStacks[btnNum]));
            cmb.setComment("Controls buttons on Crafting Screen : Capped at " + buttonCap);
            pmb.setComment("Controls buttons on Priority Screen : Capped at " + buttonCap);
            lmb.setComment("Controls buttons on Level Emitter Screen : Capped at " + buttonCap);
            this.craftByStacks[btnNum] = Math.min(this.craftByStacks[btnNum], buttonCap);
            this.priorityByStacks[btnNum] = Math.min(this.priorityByStacks[btnNum], buttonCap);
            this.levelByStacks[btnNum] = Math.min(this.levelByStacks[btnNum], buttonCap);
        }
        for (Settings e : this.settings.getSettings()) {
            String Category2 = "Client";
            Enum value = this.settings.getSetting(e);
            Property p = this.get("Client", e.name(), value.name(), this.getListComment(value));
            try {
                value = Enum.valueOf(value.getClass(), p.getString());
            }
            catch (IllegalArgumentException er) {
                AELog.info("Invalid value '" + p.getString() + "' for " + e.name() + " using '" + value.name() + "' instead", new Object[0]);
            }
            this.settings.putSetting(e, value);
        }
    }

    private String getListComment(Enum value) {
        String comment = null;
        if (value != null) {
            EnumSet set = EnumSet.allOf(value.getClass());
            for (Object Oeg : set) {
                Enum eg = (Enum)Oeg;
                if (comment == null) {
                    comment = "Possible Values: " + eg.name();
                    continue;
                }
                comment = comment + ", " + eg.name();
            }
        }
        return comment;
    }

    public boolean isFeatureEnabled(AEFeature f) {
        return this.featureFlags.contains((Object)f);
    }

    public boolean areFeaturesEnabled(Collection<AEFeature> features) {
        return this.featureFlags.containsAll(features);
    }

    public double wireless_getDrainRate(double range) {
        return this.wirelessTerminalDrainMultiplier * range;
    }

    public double wireless_getMaxRange(int boosters) {
        return this.wirelessBaseRange + this.wirelessBoosterRangeMultiplier * Math.pow(boosters, this.wirelessBoosterExp);
    }

    public double wireless_getPowerDrain(int boosters) {
        return this.wirelessBaseCost + this.wirelessCostMultiplier * Math.pow(boosters, 1.0 + (double)boosters / this.wirelessHighWirelessCount);
    }

    public Property get(String category, String key, String defaultValue, String comment, Property.Type type) {
        Property prop = super.get(category, key, defaultValue, comment, type);
        if (prop != null && !category.equals("Client")) {
            prop.setRequiresMcRestart(true);
        }
        return prop;
    }

    public void save() {
        if (this.isFeatureEnabled(AEFeature.SPATIAL_IO)) {
            this.get("spatialio", "storageProviderID", this.storageProviderID).set(this.storageProviderID);
            this.get("spatialio", "storageDimensionID", this.storageDimensionID).set(this.storageDimensionID);
        }
        this.get("Client", "PowerUnit", this.selectedPowerUnit.name(), this.getListComment(this.selectedPowerUnit)).set(this.selectedPowerUnit.name());
        if (this.hasChanged()) {
            super.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals("appliedenergistics2")) {
            this.clientSync();
        }
    }

    public boolean disableColoredCableRecipesInJEI() {
        return this.disableColoredCableRecipesInJEI;
    }

    public String getFilePath() {
        return this.configFile.toString();
    }

    public boolean useAEVersion(MaterialType mt) {
        if (this.isFeatureEnabled(AEFeature.WEBSITE_RECIPES)) {
            return true;
        }
        this.setCategoryComment("OreCamouflage", "AE2 Automatically uses alternative ores present in your instance of MC to blend better with its surroundings, if you prefer you can disable this selectively using these flags; Its important to note, that some if these items even if enabled may not be craftable in game because other items are overriding their recipes.");
        Property p = this.get("OreCamouflage", mt.name(), true);
        p.setComment("OreDictionary Names: " + mt.getOreName());
        return !p.getBoolean(true);
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum setting, Enum newValue) {
        for (Settings e : this.settings.getSettings()) {
            if (e != setting) continue;
            String Category2 = "Client";
            Property p = this.get("Client", e.name(), this.settings.getSetting(e).name(), this.getListComment(newValue));
            p.set(newValue.name());
        }
        if (this.updatable) {
            this.save();
        }
    }

    public int getFreeMaterial(int varID) {
        return this.getFreeIDSLot(varID, "materials");
    }

    public int getFreeIDSLot(int varID, String category) {
        boolean alreadyUsed = false;
        int min = 0;
        for (Property p : this.getCategory(category).getValues().values()) {
            int thisInt = p.getInt();
            if (varID == thisInt) {
                alreadyUsed = true;
            }
            min = Math.max(min, thisInt + 1);
        }
        if (alreadyUsed) {
            if (min < 16383) {
                min = 16383;
            }
            return min;
        }
        return varID;
    }

    public int getFreePart(int varID) {
        return this.getFreeIDSLot(varID, "parts");
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.settings;
    }

    public boolean useTerminalUseLargeFont() {
        return this.useLargeFonts;
    }

    public int craftItemsByStackAmounts(int i) {
        return this.craftByStacks[i];
    }

    public int priorityByStacksAmounts(int i) {
        return this.priorityByStacks[i];
    }

    public int levelByStackAmounts(int i) {
        return this.levelByStacks[i];
    }

    public int levelByMillyBuckets(int i) {
        return this.levelByMillibuckets[i];
    }

    public Enum getSetting(String category, Class<? extends Enum> class1, Enum myDefault) {
        String name = class1.getSimpleName();
        Property p = this.get(category, name, myDefault.name());
        try {
            return (Enum)class1.getField(p.toString()).get(class1);
        }
        catch (Throwable throwable) {
            return myDefault;
        }
    }

    public void setSetting(String category, Enum s) {
        String name = s.getClass().getSimpleName();
        this.get(category, name, s.name()).set(s.name());
        this.save();
    }

    public PowerUnits selectedPowerUnit() {
        return this.selectedPowerUnit;
    }

    public void nextPowerUnit(boolean backwards) {
        this.selectedPowerUnit = Platform.rotateEnum(this.selectedPowerUnit, backwards, Settings.POWER_UNITS.getPossibleValues());
        this.save();
    }

    public boolean isRemoveCrashingItemsOnLoad() {
        return this.removeCrashingItemsOnLoad;
    }

    public int getFormationPlaneEntityLimit() {
        return this.formationPlaneEntityLimit;
    }

    public boolean isEnableEffects() {
        return this.enableEffects;
    }

    public boolean isUseLargeFonts() {
        return this.useLargeFonts;
    }

    public boolean isUseColoredCraftingStatus() {
        return this.useColoredCraftingStatus;
    }

    public boolean isShowCraftableTooltip() {
        return this.showCraftableTooltip;
    }

    public boolean showPlacementPreview() {
        return this.showPlacementPreview;
    }

    public boolean isDisableColoredCableRecipesInJEI() {
        return this.disableColoredCableRecipesInJEI;
    }

    public int getCraftingCalculationTimePerTick() {
        return this.craftingCalculationTimePerTick;
    }

    public PowerUnits getSelectedPowerUnit() {
        return this.selectedPowerUnit;
    }

    public int[] getCraftByStacks() {
        return this.craftByStacks;
    }

    public int[] getPriorityByStacks() {
        return this.priorityByStacks;
    }

    public int[] getLevelByStacks() {
        return this.levelByStacks;
    }

    public int getStorageProviderID() {
        return this.storageProviderID;
    }

    void setStorageProviderID(int id) {
        this.storageProviderID = id;
    }

    public int getStorageDimensionID() {
        return this.storageDimensionID;
    }

    void setStorageDimensionID(int id) {
        this.storageDimensionID = id;
    }

    public double getSpatialPowerExponent() {
        return this.spatialPowerExponent;
    }

    public double getSpatialPowerMultiplier() {
        return this.spatialPowerMultiplier;
    }

    public String[] getGrinderOres() {
        return this.grinderOres;
    }

    public Set<String> getGrinderBlackList() {
        return this.grinderBlackList;
    }

    public double getOreDoublePercentage() {
        return this.oreDoublePercentage;
    }

    public int getWirelessTerminalBattery() {
        return this.wirelessTerminalBattery;
    }

    public int getEntropyManipulatorBattery() {
        return this.entropyManipulatorBattery;
    }

    public int getMatterCannonBattery() {
        return this.matterCannonBattery;
    }

    public int getPortableCellBattery() {
        return this.portableCellBattery;
    }

    public int getColorApplicatorBattery() {
        return this.colorApplicatorBattery;
    }

    public int getChargedStaffBattery() {
        return this.chargedStaffBattery;
    }

    public float getSpawnChargedChance() {
        return this.spawnChargedChance;
    }

    public int getQuartzOresPerCluster() {
        return this.quartzOresPerCluster;
    }

    public int getQuartzOresClusterAmount() {
        return this.quartzOresClusterAmount;
    }

    public String[] getNonBlockingItems() {
        return this.nonBlockingItems;
    }

    public int getChargedChange() {
        return this.chargedChange;
    }

    public int getMinMeteoriteDistance() {
        return this.minMeteoriteDistance;
    }

    public int getMinMeteoriteDistanceSq() {
        return this.minMeteoriteDistanceSq;
    }

    public double getMeteoriteClusterChance() {
        return this.meteoriteClusterChance;
    }

    public int getMeteoriteMaximumSpawnHeight() {
        return this.meteoriteMaximumSpawnHeight;
    }

    public int[] getMeteoriteDimensionWhitelist() {
        return this.meteoriteDimensionWhitelist;
    }

    public double getWirelessBaseCost() {
        return this.wirelessBaseCost;
    }

    public double getWirelessCostMultiplier() {
        return this.wirelessCostMultiplier;
    }

    public double getWirelessTerminalDrainMultiplier() {
        return this.wirelessTerminalDrainMultiplier;
    }

    public double getWirelessBaseRange() {
        return this.wirelessBaseRange;
    }

    public double getWirelessBoosterRangeMultiplier() {
        return this.wirelessBoosterRangeMultiplier;
    }

    public double getWirelessBoosterExp() {
        return this.wirelessBoosterExp;
    }

    public double getWirelessHighWirelessCount() {
        return this.wirelessHighWirelessCount;
    }

    public boolean getEnableCraftingSubstitutes() {
        return this.enableCraftingSubstitutes;
    }

    public int getMaxControllerSizeX() {
        return this.maxControllerSizeX;
    }

    public int getMaxControllerSizeY() {
        return this.maxControllerSizeY;
    }

    public int getMaxControllerSizeZ() {
        return this.maxControllerSizeZ;
    }

    public int getNormalChannelCapacity() {
        return this.normalChannelCapacity;
    }

    public int getDenseChannelCapacity() {
        return this.denseChannelCapacity;
    }
}

