/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.container.AEBaseContainer;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketCompressedNBT;
import appeng.core.sync.packets.PacketTargetFluidStack;
import appeng.fluids.helper.DualityFluidInterface;
import appeng.fluids.helper.IFluidInterfaceHost;
import appeng.fluids.parts.PartFluidInterface;
import appeng.fluids.tile.TileFluidInterface;
import appeng.fluids.util.AEFluidInventory;
import appeng.fluids.util.AEFluidStack;
import appeng.fluids.util.IAEFluidTank;
import appeng.helpers.InventoryAction;
import appeng.parts.reporting.PartFluidInterfaceConfigurationTerminal;
import appeng.util.Platform;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public final class ContainerFluidInterfaceConfigurationTerminal
extends AEBaseContainer {
    private static long autoBase = Long.MIN_VALUE;
    private final Map<IFluidInterfaceHost, FluidConfigTracker> diList = new HashMap<IFluidInterfaceHost, FluidConfigTracker>();
    private final Map<Long, FluidConfigTracker> byId = new HashMap<Long, FluidConfigTracker>();
    private IGrid grid;
    private NBTTagCompound data = new NBTTagCompound();
    private IAEFluidStack clientRequestedTargetFluid;

    public ContainerFluidInterfaceConfigurationTerminal(InventoryPlayer ip, PartFluidInterfaceConfigurationTerminal anchor) {
        super(ip, anchor);
        if (Platform.isServer()) {
            this.grid = anchor.getActionableNode().getGrid();
        }
        this.bindPlayerInventory(ip, 14, 153);
    }

    @Override
    public void func_75142_b() {
        IGridNode agn;
        if (Platform.isClient()) {
            return;
        }
        super.func_75142_b();
        if (this.grid == null) {
            return;
        }
        int total = 0;
        boolean missing = false;
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            DualityFluidInterface dual;
            FluidConfigTracker t;
            IFluidInterfaceHost ih;
            for (IGridNode gn : this.grid.getMachines(TileFluidInterface.class)) {
                if (!gn.isActive() || (ih = (IFluidInterfaceHost)gn.getMachine()).getDualityFluidInterface().getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.NO) continue;
                t = this.diList.get(ih);
                if (t == null) {
                    missing = true;
                } else {
                    dual = ih.getDualityFluidInterface();
                    if (!t.unlocalizedName.equals(dual.getTermName())) {
                        missing = true;
                    }
                }
                ++total;
            }
            for (IGridNode gn : this.grid.getMachines(PartFluidInterface.class)) {
                if (!gn.isActive() || (ih = (IFluidInterfaceHost)gn.getMachine()).getDualityFluidInterface().getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.NO) continue;
                t = this.diList.get(ih);
                if (t == null) {
                    missing = true;
                } else {
                    dual = ih.getDualityFluidInterface();
                    if (!t.unlocalizedName.equals(dual.getTermName())) {
                        missing = true;
                    }
                }
                ++total;
            }
        }
        if (total != this.diList.size() || missing) {
            this.regenList(this.data);
        } else {
            for (Map.Entry<IFluidInterfaceHost, FluidConfigTracker> en : this.diList.entrySet()) {
                FluidConfigTracker inv = en.getValue();
                for (int x = 0; x < inv.server.getSlots(); ++x) {
                    if ((inv.server.getFluidInSlot(x) != null || inv.client.getFluidInSlot(x) == null) && (inv.server.getFluidInSlot(x) == null || inv.server.getFluidInSlot(x).equals(inv.client.getFluidInSlot(x)))) continue;
                    this.addFluids(this.data, inv, x, 1);
                }
            }
        }
        if (!this.data.func_82582_d()) {
            try {
                NetworkHandler.instance().sendTo(new PacketCompressedNBT(this.data), (EntityPlayerMP)this.getPlayerInv().field_70458_d);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.data = new NBTTagCompound();
        }
    }

    public FluidConfigTracker getSlotByID(long id) {
        return this.byId.get(id);
    }

    @Override
    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        FluidConfigTracker inv = this.byId.get(id);
        if (inv != null) {
            ItemStack itemInHand = player.field_71071_by.func_70445_o();
            IFluidHandlerItem c = (IFluidHandlerItem)itemInHand.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (c != null) {
                FluidStack fs = c.drain(Integer.MAX_VALUE, false);
                if (fs != null) {
                    inv.server.setFluidInSlot(slot, AEFluidStack.fromFluidStack(fs));
                    return;
                }
                return;
            }
            inv.server.setFluidInSlot(slot, null);
            this.updateHeld(player);
        }
    }

    public void setTargetStack(IAEFluidStack stack) {
        if (Platform.isClient()) {
            if (stack == null && this.clientRequestedTargetFluid == null) {
                return;
            }
            if (stack != null && this.clientRequestedTargetFluid != null && stack.getFluidStack().isFluidEqual(this.clientRequestedTargetFluid.getFluidStack())) {
                return;
            }
            NetworkHandler.instance().sendToServer(new PacketTargetFluidStack((AEFluidStack)stack));
        }
        this.clientRequestedTargetFluid = stack == null ? null : stack.copy();
    }

    private void regenList(NBTTagCompound data) {
        IGridNode agn;
        this.byId.clear();
        this.diList.clear();
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            DualityFluidInterface dual;
            IFluidInterfaceHost ih;
            for (IGridNode gn : this.grid.getMachines(TileFluidInterface.class)) {
                ih = (IFluidInterfaceHost)gn.getMachine();
                dual = ih.getDualityFluidInterface();
                if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
                this.diList.put(ih, new FluidConfigTracker(dual, (AEFluidInventory)dual.getConfig(), dual.getTermName()));
            }
            for (IGridNode gn : this.grid.getMachines(PartFluidInterface.class)) {
                ih = (IFluidInterfaceHost)gn.getMachine();
                dual = ih.getDualityFluidInterface();
                if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
                this.diList.put(ih, new FluidConfigTracker(dual, (AEFluidInventory)dual.getConfig(), dual.getTermName()));
            }
        }
        data.func_74757_a("clear", true);
        for (Map.Entry<IFluidInterfaceHost, FluidConfigTracker> en : this.diList.entrySet()) {
            FluidConfigTracker inv = en.getValue();
            this.byId.put(inv.which, inv);
            this.addFluids(data, inv, 0, inv.server.getSlots());
        }
    }

    private void addFluids(NBTTagCompound data, FluidConfigTracker inv, int offset, int length) {
        String name = '=' + Long.toString(inv.which, 36);
        NBTTagCompound tag = data.func_74775_l(name);
        if (tag.func_82582_d()) {
            tag.func_74772_a("sortBy", inv.sortBy);
            tag.func_74778_a("un", inv.unlocalizedName);
            tag.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)inv.pos));
            tag.func_74768_a("dim", inv.dim);
        }
        for (int x = 0; x < length; ++x) {
            NBTTagCompound fluidNBT = new NBTTagCompound();
            IAEFluidStack iaeFluidStack = inv.server.getFluidInSlot(x + offset);
            inv.client.setFluidInSlot(x + offset, iaeFluidStack == null ? null : iaeFluidStack.copy());
            if (iaeFluidStack != null) {
                iaeFluidStack.writeToNBT(fluidNBT);
            }
            tag.func_74782_a(Integer.toString(x + offset), (NBTBase)fluidNBT);
        }
        data.func_74782_a(name, (NBTBase)tag);
    }

    static /* synthetic */ long access$708() {
        return autoBase++;
    }

    public static class FluidConfigTracker {
        private final long sortBy;
        private final long which = ContainerFluidInterfaceConfigurationTerminal.access$708();
        private final String unlocalizedName;
        private final IAEFluidTank client;
        private final IAEFluidTank server;
        private final BlockPos pos;
        private final int dim;

        public FluidConfigTracker(DualityFluidInterface dual, AEFluidInventory configSlots, String unlocalizedName) {
            this.server = configSlots;
            this.client = new AEFluidInventory(null, this.server.getSlots());
            this.unlocalizedName = unlocalizedName;
            this.sortBy = dual.getSortValue();
            this.pos = dual.getLocation().getPos();
            this.dim = dual.getLocation().getWorld().field_73011_w.getDimension();
        }

        public IAEFluidTank getServer() {
            return this.server;
        }
    }
}

