/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.api.storage.data.IAEItemStack;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.util.ISlimReadableNumberConverter;
import appeng.util.IWideReadableNumberConverter;
import appeng.util.ReadableNumberConverter;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;

public class StackSizeRenderer {
    private static final ISlimReadableNumberConverter SLIM_CONVERTER = ReadableNumberConverter.INSTANCE;
    private static final IWideReadableNumberConverter WIDE_CONVERTER = ReadableNumberConverter.INSTANCE;

    public void renderStackSize(FontRenderer fontRenderer, IAEItemStack aeStack, int xPos, int yPos) {
        if (aeStack != null) {
            float scaleFactor = AEConfig.instance().useTerminalUseLargeFont() ? 0.85f : 0.5f;
            float inverseScaleFactor = 1.0f / scaleFactor;
            int offset = AEConfig.instance().useTerminalUseLargeFont() ? 0 : -1;
            boolean unicodeFlag = fontRenderer.func_82883_a();
            fontRenderer.func_78264_a(false);
            if ((aeStack.getStackSize() == 0L || GuiScreen.func_175283_s()) && aeStack.isCraftable()) {
                String craftLabelText = AEConfig.instance().useTerminalUseLargeFont() ? GuiText.LargeFontCraft.getLocal() : GuiText.SmallFontCraft.getLocal();
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179084_k();
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scaleFactor, (float)scaleFactor, (float)scaleFactor);
                int X = (int)(((float)xPos + (float)offset + 16.0f - (float)fontRenderer.func_78256_a(craftLabelText) * scaleFactor) * inverseScaleFactor);
                int Y = (int)(((float)yPos + (float)offset + 16.0f - 7.0f * scaleFactor) * inverseScaleFactor);
                fontRenderer.func_175063_a(craftLabelText, (float)X, (float)Y, 0xFFFFFF);
                GlStateManager.func_179121_F();
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
                GlStateManager.func_179147_l();
            } else if (aeStack.getStackSize() > 0L) {
                String stackSize = this.getToBeRenderedStackSize(aeStack.getStackSize());
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179084_k();
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scaleFactor, (float)scaleFactor, (float)scaleFactor);
                int X = (int)(((float)xPos + (float)offset + 16.0f - (float)fontRenderer.func_78256_a(stackSize) * scaleFactor) * inverseScaleFactor);
                int Y = (int)(((float)yPos + (float)offset + 16.0f - 7.0f * scaleFactor) * inverseScaleFactor);
                fontRenderer.func_175063_a(stackSize, (float)X, (float)Y, 0xFFFFFF);
                GlStateManager.func_179121_F();
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
                GlStateManager.func_179147_l();
            }
            fontRenderer.func_78264_a(unicodeFlag);
        }
    }

    private String getToBeRenderedStackSize(long originalSize) {
        if (AEConfig.instance().useTerminalUseLargeFont()) {
            return SLIM_CONVERTER.toSlimReadableForm(originalSize);
        }
        return WIDE_CONVERTER.toWideReadableForm(originalSize);
    }
}

