/*
 * Decompiled with CFR 0.152.
 */
package appeng.bootstrap;

import appeng.bootstrap.FeatureFactory;
import appeng.bootstrap.IItemRendering;
import appeng.bootstrap.components.ItemColorComponent;
import appeng.bootstrap.components.ItemMeshDefinitionComponent;
import appeng.bootstrap.components.ItemModelComponent;
import appeng.bootstrap.components.ItemVariantsComponent;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

class ItemRendering
implements IItemRendering {
    @SideOnly(value=Side.CLIENT)
    private IItemColor itemColor;
    @SideOnly(value=Side.CLIENT)
    private ItemMeshDefinition itemMeshDefinition;
    @SideOnly(value=Side.CLIENT)
    private final Map<Integer, ModelResourceLocation> itemModels = new HashMap<Integer, ModelResourceLocation>();
    @SideOnly(value=Side.CLIENT)
    private final Set<ResourceLocation> variants = new HashSet<ResourceLocation>();
    @SideOnly(value=Side.CLIENT)
    private final Map<String, IModel> builtInModels = new HashMap<String, IModel>();

    ItemRendering() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemRendering meshDefinition(ItemMeshDefinition meshDefinition) {
        this.itemMeshDefinition = meshDefinition;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemRendering model(int meta, ModelResourceLocation model) {
        this.itemModels.put(meta, model);
        return this;
    }

    @Override
    public IItemRendering variants(Collection<ResourceLocation> resources) {
        this.variants.addAll(resources);
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemRendering color(IItemColor itemColor) {
        this.itemColor = itemColor;
        return this;
    }

    @Override
    public IItemRendering builtInModel(String name, IModel model) {
        this.builtInModels.put(name, model);
        return this;
    }

    void apply(FeatureFactory factory, Item item) {
        if (this.itemMeshDefinition != null) {
            factory.addBootstrapComponent(new ItemMeshDefinitionComponent(item, this.itemMeshDefinition));
        }
        if (!this.itemModels.isEmpty()) {
            factory.addBootstrapComponent(new ItemModelComponent(item, this.itemModels));
        }
        HashSet<ResourceLocation> resources = new HashSet<ResourceLocation>(this.variants);
        if (this.itemMeshDefinition == null && this.itemModels.isEmpty()) {
            ModelResourceLocation model;
            if (item instanceof ItemBlock) {
                Block block = ((ItemBlock)item).func_179223_d();
                StateMapperHelper helper = new StateMapperHelper(item.getRegistryName());
                model = helper.func_178132_a(block.func_176223_P());
            } else {
                model = new ModelResourceLocation(item.getRegistryName(), "inventory");
            }
            factory.addBootstrapComponent(new ItemModelComponent(item, (Map<Integer, ModelResourceLocation>)ImmutableMap.of((Object)0, (Object)model)));
        }
        this.builtInModels.forEach(factory::addBuiltInModel);
        if (!resources.isEmpty()) {
            factory.addBootstrapComponent(new ItemVariantsComponent(item, resources));
        } else if (this.itemMeshDefinition != null) {
            factory.addBootstrapComponent(new ItemVariantsComponent(item, Collections.emptyList()));
        }
        if (this.itemColor != null) {
            factory.addBootstrapComponent(new ItemColorComponent(item, this.itemColor));
        }
    }

    private static class StateMapperHelper
    extends StateMapperBase {
        private final ResourceLocation registryName;

        public StateMapperHelper(ResourceLocation registryName) {
            this.registryName = registryName;
        }

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            return new ModelResourceLocation(this.registryName, this.func_178131_a((Map)state.func_177228_b()));
        }
    }
}

