/*
 * Decompiled with CFR 0.152.
 */
package mixu.astrallevelnerf.asm;

import mixu.astrallevelnerf.AstralLevelNerf;
import mixu.astrallevelnerf.asm.AstralLevelNerfPlugin;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class AstralLevelNerfTransformer
implements IClassTransformer {
    private static final String classToTransform = "hellfirepvp.astralsorcery.common.constellation.perk.PerkLevelManager";
    private static final String astralFunction = "ensureLevels";

    private static boolean isStartNode(AbstractInsnNode node) {
        if (node == null || node.getNext() == null) {
            return false;
        }
        return node.getOpcode() == 18 && node.getNext().getOpcode() == 97 && node.getNext().getNext().getOpcode() == 18;
    }

    private static boolean isEndNode(AbstractInsnNode node) {
        if (node == null || node.getNext() == null) {
            return false;
        }
        return node.getOpcode() == 97 && node.getNext().getOpcode() == 184;
    }

    public byte[] transform(String name, String transformedName, byte[] classBeingTransformed) {
        if (transformedName.equals(classToTransform)) {
            return this.transform(transformedName, classBeingTransformed);
        }
        return classBeingTransformed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] transform(String className, byte[] classBeingTransformed) {
        boolean ok = true;
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(classBeingTransformed);
            classReader.accept((ClassVisitor)classNode, 0);
            this.transformAstral(classNode);
            ClassWriter classWriter = new ClassWriter(3);
            classNode.accept((ClassVisitor)classWriter);
            byte[] byArray = classWriter.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            ok = false;
            AstralLevelNerfPlugin.logger.error("Failed to transform astral level function!");
            AstralLevelNerfPlugin.logger.error((Object)e);
        }
        finally {
            if (ok) {
                AstralLevelNerfPlugin.logger.info("Transformed astral level function successfully");
            }
        }
        return classBeingTransformed;
    }

    private void transformAstral(ClassNode clazz) {
        for (MethodNode method : clazz.methods) {
            if (!method.name.equals(astralFunction)) continue;
            AbstractInsnNode start = null;
            AbstractInsnNode end = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (AstralLevelNerfTransformer.isStartNode(instruction)) {
                    AstralLevelNerfPlugin.logger.info("Found start");
                    start = instruction;
                    continue;
                }
                if (!AstralLevelNerfTransformer.isEndNode(instruction)) continue;
                AstralLevelNerfPlugin.logger.info("Found end");
                end = instruction.getNext().getNext();
                break;
            }
            if (start == null || end == null) {
                throw new NullPointerException("Start or end node not found!");
            }
            boolean started = false;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (!AstralLevelNerfTransformer.isStartNode(instruction) && !started) continue;
                start = start.getOpcode() == 22 ? start : start.getPrevious();
                boolean bl = started = started || AstralLevelNerfTransformer.isStartNode(instruction);
                if (instruction.getOpcode() == 185) {
                    end = instruction;
                    break;
                }
                method.instructions.remove(instruction);
            }
            InsnList index = new InsnList();
            index.add((AbstractInsnNode)new VarInsnNode(21, 1));
            index.add((AbstractInsnNode)new InsnNode(0));
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(AstralLevelNerf.class), "getExpRequired", "(IJ)J", false));
            list.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false));
            method.instructions.insertBefore(start, index);
            method.instructions.insertBefore(end, list);
        }
    }
}

