/*
 * Decompiled with CFR 0.152.
 */
package mirror.normalasm.common.crashes;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import mirror.normalasm.NormalLogger;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.FMLContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.MinecraftDummyContainer;
import net.minecraftforge.fml.common.ModContainer;

public class ModIdentifier {
    public static Set<ModContainer> identifyFromStacktrace(Throwable e) {
        Map<File, Set<ModContainer>> modMap = ModIdentifier.makeModMap();
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        while (e != null) {
            for (StackTraceElement element : e.getStackTrace()) {
                classes.add(element.getClassName());
            }
            e = e.getCause();
        }
        LinkedHashSet<ModContainer> mods = new LinkedHashSet<ModContainer>();
        for (String className : classes) {
            Set<ModContainer> classMods = ModIdentifier.identifyFromClass(className, modMap);
            if (classMods == null) continue;
            mods.addAll(classMods);
        }
        return mods;
    }

    public static Set<ModContainer> identifyFromClass(String className) {
        return ModIdentifier.identifyFromClass(className, ModIdentifier.makeModMap());
    }

    private static Set<ModContainer> identifyFromClass(String className, Map<File, Set<ModContainer>> modMap) {
        if (className.startsWith("org.spongepowered.asm.mixin.") || className.startsWith("sun.") || className.startsWith("java.")) {
            return Collections.emptySet();
        }
        String untrasformedName = ModIdentifier.untransformName(Launch.classLoader, className);
        URL url = Launch.classLoader.getResource(untrasformedName.replace('.', '/') + ".class");
        NormalLogger.instance.debug(className + " = " + untrasformedName + " = " + url);
        if (url == null) {
            NormalLogger.instance.warn("Failed to identify " + className + " (untransformed name: " + untrasformedName + ")");
            return Collections.emptySet();
        }
        try {
            if (url.getProtocol().equals("jar")) {
                url = new URL(url.getFile().substring(0, url.getFile().indexOf(33)));
            }
            return modMap.get(new File(url.toURI()).getCanonicalFile());
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<File, Set<ModContainer>> makeModMap() {
        Object2ObjectOpenHashMap modMap = new Object2ObjectOpenHashMap();
        for (ModContainer mod : Loader.instance().getModList()) {
            if (mod instanceof MinecraftDummyContainer || mod instanceof FMLContainer) continue;
            try {
                modMap.computeIfAbsent(mod.getSource().getCanonicalFile(), k -> new ObjectArraySet()).add(mod);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return modMap;
    }

    private static String untransformName(LaunchClassLoader launchClassLoader, String className) {
        try {
            Method untransformNameMethod = LaunchClassLoader.class.getDeclaredMethod("untransformName", String.class);
            untransformNameMethod.setAccessible(true);
            return (String)untransformNameMethod.invoke((Object)launchClassLoader, className);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

