/*
 * Decompiled with CFR 0.152.
 */
package mirror.normalasm.client.sprite;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mirror.normalasm.NormalLogger;
import mirror.normalasm.NormalReflector;
import mirror.normalasm.common.internal.mixins.TextureMapAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class FramesTextureData
extends ArrayList<int[][]> {
    private static final Class<?> FOAMFIX_SPRITE = NormalReflector.getNullableClass("pl.asie.foamfix.client.FastTextureAtlasSprite");
    private static final int INACTIVITY_THRESHOLD = 20;
    private static boolean canReload = true;
    private static final Set<FramesTextureData> tickingSpritesSet = new ReferenceLinkedOpenHashSet();
    private final TextureAtlasSprite sprite;
    private int ticksInactive;

    @SubscribeEvent
    public static void registerEvictionListener(ColorHandlerEvent.Block event) {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)((ISelectiveResourceReloadListener)(manager, predicate) -> {
            if (predicate.test(VanillaResourceType.MODELS)) {
                canReload = false;
                int count = 0;
                ObjectOpenHashSet skippedSpriteClasses = new ObjectOpenHashSet();
                try {
                    Set<FramesTextureData> set = tickingSpritesSet;
                    synchronized (set) {
                        tickingSpritesSet.clear();
                    }
                    for (TextureAtlasSprite sprite : ((TextureMapAccessor)Minecraft.func_71410_x().func_147117_R()).getMapRegisteredSprites().values()) {
                        if (sprite.func_130098_m()) continue;
                        if (sprite.getClass() == FOAMFIX_SPRITE || sprite.getClass() == TextureAtlasSprite.class) {
                            ++count;
                            sprite.func_110968_a((List)new FramesTextureData(sprite));
                            continue;
                        }
                        skippedSpriteClasses.add(sprite.getClass());
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                NormalLogger.instance.info("Evicted {} sprites' frame texture data", (Object)count);
                NormalLogger.instance.debug("While evicting sprites' frame texture data, the following classes were skipped: [{}]", (Object)skippedSpriteClasses.stream().map(Class::getName).collect(Collectors.joining(", ")));
                canReload = true;
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList<FramesTextureData> toTick;
            Set<FramesTextureData> set = tickingSpritesSet;
            synchronized (set) {
                toTick = new ArrayList<FramesTextureData>(tickingSpritesSet);
            }
            for (FramesTextureData data : toTick) {
                if (!data.tick()) continue;
                Set<FramesTextureData> set2 = tickingSpritesSet;
                synchronized (set2) {
                    tickingSpritesSet.remove(data);
                }
            }
        }
    }

    public FramesTextureData(TextureAtlasSprite sprite) {
        this.sprite = sprite;
        this.ticksInactive = 21;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tick() {
        FramesTextureData framesTextureData = this;
        synchronized (framesTextureData) {
            ++this.ticksInactive;
            if (this.ticksInactive == 20) {
                this.clear();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markActive() {
        this.ticksInactive = 0;
        Set<FramesTextureData> set = tickingSpritesSet;
        synchronized (set) {
            tickingSpritesSet.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[][] get(int index) {
        FramesTextureData framesTextureData = this;
        synchronized (framesTextureData) {
            if (canReload && super.isEmpty()) {
                this.load();
            }
            this.markActive();
            return (int[][])super.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        FramesTextureData framesTextureData = this;
        synchronized (framesTextureData) {
            if (canReload && super.isEmpty()) {
                this.load();
            }
            this.markActive();
            return super.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        FramesTextureData framesTextureData = this;
        synchronized (framesTextureData) {
            if (canReload && super.isEmpty()) {
                this.load();
            }
            this.markActive();
            return super.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        FramesTextureData framesTextureData = this;
        synchronized (framesTextureData) {
            super.clear();
            this.trimToSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        block19: {
            boolean oldReload = canReload;
            canReload = false;
            try {
                ResourceLocation location = this.getLocation();
                IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
                TextureMap textureMap = Minecraft.func_71410_x().func_147117_R();
                if (this.sprite.hasCustomLoader(resourceManager, location)) {
                    this.sprite.load(resourceManager, location, rl -> textureMap.func_110572_b(rl.toString()));
                    break block19;
                }
                int mipLevels = Minecraft.func_71410_x().field_71474_y.field_151442_I;
                try (IResource resource = resourceManager.func_110536_a(location);){
                    this.sprite.func_188539_a(resource, mipLevels + 1);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                for (int i = 0; i < this.size(); ++i) {
                    int[][] aint = this.get(i);
                    if (aint == null) continue;
                    this.set(i, TextureUtil.func_147949_a((int)mipLevels, (int)this.sprite.func_94211_a(), (int[][])aint));
                }
            }
            finally {
                canReload = oldReload;
            }
        }
    }

    private ResourceLocation getLocation() {
        String[] parts = ResourceLocation.func_177516_a((String)this.sprite.func_94215_i());
        return new ResourceLocation(parts[0], String.format("%s/%s%s", Minecraft.func_71410_x().func_147117_R().getBasePath(), parts[1], ".png"));
    }
}

