/*
 * Decompiled with CFR 0.152.
 */
package mirror.normalasm.client.models.bucket;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import org.apache.commons.lang3.tuple.Pair;

public class NormalBakedDynBucket
extends BakedItemModel {
    public static final Map<ResourceLocation, Pair<ResourceLocation, BakedQuad[]>> baseQuads = new Object2ObjectOpenHashMap();
    public static final Map<ResourceLocation, Pair<ResourceLocation, BakedQuad[]>> flippedBaseQuads = new Object2ObjectOpenHashMap();
    public static final Map<ResourceLocation, BakedQuad[]> coverQuads = new Object2ObjectOpenHashMap();
    public static final Map<ResourceLocation, BakedQuad[]> flippedCoverQuads = new Object2ObjectOpenHashMap();
    private final ModelDynBucket parent;
    private final VertexFormat format;
    private final Cache<String, IBakedModel> bucketVariants;

    public NormalBakedDynBucket(ModelDynBucket parent, ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, boolean untransformed) {
        super(quads, particle, transforms, (ItemOverrideList)NormalBakedDynBucketOverrdeList.INSTANCE, untransformed);
        this.parent = parent;
        this.format = format;
        this.bucketVariants = CacheBuilder.newBuilder().weakValues().build();
    }

    private static final class NormalBakedDynBucketOverrdeList
    extends ItemOverrideList {
        private static final NormalBakedDynBucketOverrdeList INSTANCE = new NormalBakedDynBucketOverrdeList();

        private NormalBakedDynBucketOverrdeList() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
            if (fluidStack == null) {
                return originalModel;
            }
            NormalBakedDynBucket bakedModel = (NormalBakedDynBucket)originalModel;
            try {
                return (IBakedModel)bakedModel.bucketVariants.get((Object)fluidStack.getFluid().getName(), () -> this.bake(bakedModel, fluidStack.getFluid().getName()));
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                return this.bake(bakedModel, fluidStack.getFluid().getName());
            }
        }

        private IBakedModel bake(NormalBakedDynBucket bakedModel, String fluidName) {
            ModelDynBucket parent = bakedModel.parent.process(ImmutableMap.of((Object)"fluid", (Object)fluidName));
            return parent.bake((IModelState)new SimpleModelState(bakedModel.transforms), bakedModel.format, ModelLoader.defaultTextureGetter());
        }
    }
}

