/*
 * Decompiled with CFR 0.152.
 */
package mirror.normalasm.api.datastructures;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mirror.normalasm.api.datastructures.canonical.AutoCanonizingArrayMap;
import mirror.normalasm.api.datastructures.canonical.AutoCanonizingHashMap;
import mirror.normalasm.config.NormalConfig;

public class NormalTagMap<K, V>
implements Map<K, V> {
    private Map<K, V> map;
    private final int threshold;

    public NormalTagMap() {
        this(NormalConfig.instance.optimizeNBTTagCompoundMapThreshold, NormalConfig.instance.nbtBackingMapStringCanonicalization, NormalConfig.instance.optimizeNBTTagCompoundBackingMap);
    }

    public NormalTagMap(int threshold, boolean canonicalizeString, boolean optimizeMap) {
        int n = this.threshold = optimizeMap ? threshold : -1;
        this.map = canonicalizeString ? (optimizeMap ? new AutoCanonizingArrayMap() : new AutoCanonizingHashMap()) : (optimizeMap ? new Object2ObjectArrayMap() : new Object2ObjectOpenHashMap());
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (this.size() == this.threshold) {
            this.map = this.map instanceof AutoCanonizingArrayMap ? new AutoCanonizingHashMap<K, V>(this.map) : new Object2ObjectOpenHashMap(this.map);
        }
        return this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        m.forEach(this::put);
    }

    @Override
    public void clear() {
        if (this.threshold != -1) {
            if (this.map instanceof AutoCanonizingHashMap) {
                this.map = new AutoCanonizingArrayMap();
            } else if (this.map instanceof Object2ObjectOpenHashMap) {
                this.map = new Object2ObjectArrayMap();
            } else {
                this.map.clear();
            }
        } else {
            this.map.clear();
        }
    }

    @Override
    @Nonnull
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    @Nonnull
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map o = (Map)obj;
        if (o.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(o.entrySet());
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }
}

