/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.tiles;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import sblectric.lightningcraft.api.capabilities.implementation.BaseLightningUpgradable;
import sblectric.lightningcraft.init.LCCapabilities;
import sblectric.lightningcraft.tiles.TileEntityLightningUser;
import sblectric.lightningcraft.tiles.ifaces.ISidedInventoryLC;
import sblectric.lightningcraft.util.LCMisc;

public abstract class TileEntityLightningItemHandler
extends TileEntityLightningUser
implements ISidedInventoryLC {
    protected SidedInvWrapper[] itemCapabilities = LCMisc.makeInvWrapper(this);
    private ItemStack[] stacks = new ItemStack[0];

    public void setSizeInventory(int size) {
        this.stacks = new ItemStack[size];
        for (int i = 0; i < size; ++i) {
            this.stacks[i] = ItemStack.field_190927_a;
        }
    }

    public int func_70302_i_() {
        return this.stacks.length;
    }

    @Nonnull
    public ItemStack getStack(int index) {
        if (index >= this.stacks.length) {
            return ItemStack.field_190927_a;
        }
        return this.stacks[index];
    }

    public boolean setStack(int index, @Nonnull ItemStack stack) {
        if (index >= this.stacks.length) {
            return false;
        }
        this.stacks[index] = stack;
        return true;
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        return this.stacks[slot];
    }

    @Nonnull
    public ItemStack func_70298_a(int par1, int par2) {
        if (!this.stacks[par1].func_190926_b()) {
            if (this.stacks[par1].func_190916_E() <= par2) {
                ItemStack itemstack = this.stacks[par1];
                this.stacks[par1] = ItemStack.field_190927_a;
                return itemstack;
            }
            ItemStack itemstack = this.stacks[par1].func_77979_a(par2);
            if (this.stacks[par1].func_190916_E() == 0) {
                this.stacks[par1] = ItemStack.field_190927_a;
            }
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_70304_b(int slot) {
        if (!this.stacks[slot].func_190926_b()) {
            ItemStack itemstack = this.stacks[slot];
            this.stacks[slot] = ItemStack.field_190927_a;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slot, @Nonnull ItemStack itemstack) {
        this.stacks[slot] = itemstack;
        if (!itemstack.func_190926_b() && itemstack.func_190916_E() > this.func_70297_j_()) {
            itemstack.func_190920_e(this.func_70297_j_());
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemCapabilities[facing.func_176745_a()];
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        this.setSizeInventory(this.func_70302_i_());
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound slotTag = tagList.func_150305_b(i);
            byte slot = slotTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.stacks.length) continue;
            this.stacks[slot] = new ItemStack(slotTag);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.stacks.length; ++i) {
            if (this.stacks[i].func_190926_b()) continue;
            NBTTagCompound slotTag = new NBTTagCompound();
            slotTag.func_74774_a("Slot", (byte)i);
            this.stacks[i].func_77955_b(slotTag);
            tagList.func_74742_a((NBTBase)slotTag);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tagList);
        return tagCompound;
    }

    public static abstract class Upgradable
    extends TileEntityLightningItemHandler {
        private BaseLightningUpgradable upgrade = new BaseLightningUpgradable();

        @Override
        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            if (capability == LCCapabilities.LIGHTNING_UPGRADABLE) {
                return true;
            }
            return super.hasCapability(capability, facing);
        }

        @Override
        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == LCCapabilities.LIGHTNING_UPGRADABLE) {
                return (T)this.upgrade;
            }
            return super.getCapability(capability, facing);
        }

        public boolean isUpgraded() {
            return this.upgrade.isUpgraded();
        }

        public void setUpgraded(boolean upgraded) {
            this.upgrade.setUpgraded(upgraded);
        }

        @Override
        public void func_145839_a(NBTTagCompound tagCompound) {
            super.func_145839_a(tagCompound);
            this.upgrade.deserializeNBT(tagCompound);
        }

        @Override
        public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
            super.func_189515_b(tagCompound);
            return this.upgrade.serializeNBT(tagCompound);
        }

        public String func_70005_c_() {
            return this.func_145838_q().func_149732_F() + (this.isUpgraded() ? " (Upgr.)" : "");
        }

        public boolean func_145818_k_() {
            return true;
        }
    }
}

