/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.tiles;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sblectric.lightningcraft.api.IFurnace;
import sblectric.lightningcraft.tiles.TileEntityLightningItemHandler;
import sblectric.lightningcraft.util.LCMisc;

public class TileEntityEnchReallocator
extends TileEntityLightningItemHandler.Upgradable {
    private static final int top = 0;
    private static final int bottom = 1;
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{1};
    private static final int[] slotsSides = new int[]{0, 1};
    private static final int lpBurnTime = 200;
    public int reallocBurnTime;
    public int reallocCookTime;
    public int currentBurnTime;
    private boolean redo;
    public List<NBTTagCompound> topEnchs;
    public int nTopEnchs;
    public int lpCost;
    public int xpCost;
    public int xpPlayer;
    public EntityPlayer player = null;
    public boolean hasPlayer = false;

    public TileEntityEnchReallocator() {
        this.setSizeInventory(2);
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public int getReallocProgressScaled(int par1) {
        return this.reallocCookTime * par1 / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getReallocTimeRemainingScaled(int par1) {
        if (this.currentBurnTime == 0) {
            this.currentBurnTime = 200;
        }
        return this.reallocBurnTime * par1 / this.currentBurnTime;
    }

    public boolean isBurning() {
        return this.reallocBurnTime > 0;
    }

    public void func_73660_a() {
        boolean flag = this.reallocBurnTime > 0;
        boolean dosave = false;
        if (this.reallocBurnTime > 0) {
            --this.reallocBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.reallocBurnTime == 0 && this.canReallocate()) {
                this.reallocBurnTime = 200;
                this.currentBurnTime = 200;
                if (this.reallocBurnTime > 0) {
                    dosave = true;
                }
            }
            if (this.isBurning() && this.canReallocate()) {
                ++this.reallocCookTime;
                if (this.reallocCookTime == 200) {
                    this.reallocCookTime = 0;
                    this.reallocateEnchs();
                    dosave = true;
                }
            } else {
                this.reallocCookTime = 0;
            }
            if (flag != this.reallocBurnTime > 0) {
                dosave = true;
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                ((IFurnace)state.func_177230_c()).setBurning(state, (IBlockAccess)this.field_145850_b, this.field_174879_c, this.reallocBurnTime > 0);
            }
        }
        if (dosave) {
            this.func_70296_d();
        }
        if (this.isUpgraded() && !this.redo) {
            this.redo = true;
            this.func_73660_a();
        }
        this.redo = false;
    }

    private boolean canReallocate() {
        this.topEnchs = null;
        this.xpCost = -1;
        this.lpCost = -1;
        this.nTopEnchs = 0;
        if (!this.hasLPCell()) {
            return false;
        }
        ItemStack top = this.getStack(0);
        ItemStack bottom = this.getStack(1);
        List<NBTTagCompound> topEnchs = LCMisc.getEnchantments(top);
        if (!topEnchs.isEmpty()) {
            this.topEnchs = topEnchs;
            this.nTopEnchs = topEnchs.size();
        }
        if (top != null && bottom != null && !topEnchs.isEmpty() && (bottom.func_77956_u() || bottom.func_77973_b() == Items.field_151122_aG)) {
            this.xpCost = top.func_82838_A() + bottom.func_82838_A() + 5;
            this.lpCost = 50 + this.xpCost;
            return this.canDrawCellPower(this.lpCost) && this.xpCost <= this.xpPlayer && this.player != null && this.hasPlayer;
        }
        return false;
    }

    private void reallocateEnchs() {
        if (this.canReallocate()) {
            this.drawCellPower(this.lpCost);
            if (!this.player.field_71075_bZ.field_75098_d) {
                ((EntityPlayerMP)this.player).func_82242_a(-this.xpCost);
            }
            this.hasPlayer = false;
            int topCost = this.getStack(0).func_82838_A();
            int bottomCost = this.getStack(1).func_82838_A();
            if (this.getStack(0).func_77973_b() == Items.field_151134_bR) {
                this.setStack(0, new ItemStack(Items.field_151122_aG, 1));
            } else if (this.getStack(0).func_77978_p().func_74764_b("ench")) {
                this.getStack(0).func_77978_p().func_82580_o("ench");
            }
            this.getStack(0).func_82841_c(topCost + 5);
            if (this.getStack(1).func_77973_b() == Items.field_151122_aG) {
                this.setStack(1, new ItemStack(Items.field_151134_bR, 1));
            }
            LCMisc.addEnchantments(this.getStack(1), this.topEnchs);
            this.getStack(1).func_82841_c(bottomCost + 5);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.reallocBurnTime = tagCompound.func_74765_d("BurnTime");
        this.reallocCookTime = tagCompound.func_74765_d("CookTime");
        this.currentBurnTime = 200;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74777_a("BurnTime", (short)this.reallocBurnTime);
        tagCompound.func_74777_a("CookTime", (short)this.reallocBurnTime);
        return tagCompound;
    }

    public boolean func_94041_b(int par1, ItemStack itemstack) {
        return true;
    }

    public int[] func_180463_a(EnumFacing facing) {
        return facing == EnumFacing.DOWN ? slotsBottom : (facing == EnumFacing.UP ? slotsTop : slotsSides);
    }

    public boolean func_180462_a(int slot, ItemStack itemstack, EnumFacing facing) {
        return this.func_94041_b(slot, itemstack);
    }

    public boolean func_180461_b(int slot, ItemStack itemstack, EnumFacing facing) {
        return true;
    }
}

