/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sblectric.lightningcraft.init.LCParticles;
import sblectric.lightningcraft.ref.RefMisc;

public class MessageSpawnParticle
implements IMessage {
    private String name;
    private double x;
    private double y;
    private double z;
    private double vx;
    private double vy;
    private double vz;

    public MessageSpawnParticle() {
    }

    public MessageSpawnParticle(String name, double x, double y, double z, double vx, double vy, double vz) {
        this.name = name;
        this.x = x;
        this.y = y;
        this.z = z;
        this.vx = vx;
        this.vy = vy;
        this.vz = vz;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.name = tag.func_74779_i("name");
        this.x = tag.func_74769_h("x");
        this.y = tag.func_74769_h("y");
        this.z = tag.func_74769_h("z");
        this.vx = tag.func_74769_h("vx");
        this.vy = tag.func_74769_h("vy");
        this.vz = tag.func_74769_h("vz");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("name", this.name);
        tag.func_74780_a("x", this.x);
        tag.func_74780_a("y", this.y);
        tag.func_74780_a("z", this.z);
        tag.func_74780_a("vx", this.vx);
        tag.func_74780_a("vy", this.vy);
        tag.func_74780_a("vz", this.vz);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class Handler
    implements IMessageHandler<MessageSpawnParticle, IMessage> {
        public IMessage onMessage(MessageSpawnParticle m, MessageContext ctx) {
            if (RefMisc.DEBUG) {
                System.out.println("Spawning particle");
            }
            Minecraft.func_71410_x().func_152344_a(() -> LCParticles.spawnParticle(m.name, m.x, m.y, m.z, m.vx, m.vy, m.vz));
            return null;
        }
    }
}

