/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.render.CCModel;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ModelHelper {
    public static CCModel quadulate(CCModel inModel) {
        if (inModel.vertexMode == 7) {
            throw new IllegalArgumentException("Cannot quadulate a quad model. Check if the model is triangles before calling this");
        }
        LinkedList verts = new LinkedList();
        Iterator iter = verts.iterator();
        while (iter.hasNext()) {
            verts.add(iter.next());
            verts.add(iter.next());
            Vertex5 copy = (Vertex5)iter.next();
            verts.add(copy);
            verts.add(copy.copy());
        }
        CCModel outModel = CCModel.quadModel(verts.size());
        outModel.verts = verts.toArray(outModel.verts);
        return outModel;
    }

    public static CCModel simplifyModel(CCModel model) {
        LinkedList<Vertex5> verts = new LinkedList<Vertex5>();
        Collections.addAll(verts, model.getVertices());
        LinkedList<Vertex5> combinedVerts = ModelHelper.simplifyModel(verts);
        CCModel outModel = CCModel.quadModel(combinedVerts.size());
        outModel.verts = combinedVerts.toArray(outModel.verts);
        return outModel;
    }

    public static LinkedList<Vertex5> simplifyModel(List<Vertex5> in) {
        LinkedList<Face> faces = new LinkedList<Face>();
        Iterator<Vertex5> iter = in.iterator();
        while (iter.hasNext()) {
            Face f = Face.loadFromIterator(iter);
            faces.removeIf(f::attemptToCombine);
            faces.add(f);
        }
        LinkedList<Vertex5> out = new LinkedList<Vertex5>();
        for (Face f : faces) {
            Collections.addAll(out, f.verts);
        }
        return out;
    }

    private static class Face {
        public Vertex5[] verts;

        public static Face loadFromIterator(Iterator<Vertex5> iter) {
            Face f = new Face(new Vertex5[4]);
            for (int i = 0; i < 4; ++i) {
                f.verts[i] = iter.next();
            }
            return f;
        }

        public Vertex5 vec(int s) {
            return this.verts[s & 3];
        }

        public void setVec(int s, Vertex5 newVec) {
            this.verts[s & 3] = newVec;
        }

        public Face(Vertex5 ... v) {
            assert (v.length == 4);
            this.verts = v;
        }

        public boolean isPolygon() {
            for (int i = 0; i < 4; ++i) {
                if (!this.vec((int)i).vec.equalsT(this.vec((int)(i + 1)).vec)) continue;
                return true;
            }
            return false;
        }

        public Face reverse() {
            this.verts = new Vertex5[]{this.verts[3], this.verts[2], this.verts[1], this.verts[0]};
            return this;
        }

        public boolean attemptToCombine(Face other) {
            if (this.isPolygon() || other.isPolygon()) {
                return false;
            }
            if (this.attemptToCombineUnflipped(other)) {
                return true;
            }
            this.reverse();
            if (this.attemptToCombineUnflipped(other)) {
                return true;
            }
            this.reverse();
            other.reverse();
            if (this.attemptToCombineUnflipped(other)) {
                return true;
            }
            this.reverse();
            if (this.attemptToCombineUnflipped(other)) {
                return true;
            }
            this.reverse();
            other.reverse();
            return false;
        }

        public boolean equalVert(Vertex5 a, Vertex5 b) {
            return a.vec.equalsT(b.vec) && a.uv.equals(b.uv);
        }

        public boolean attemptToCombineUnflipped(Face other) {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (!this.equalVert(this.vec(i), this.vec(j)) || !this.equalVert(this.vec(i + 1), this.vec(j - 1))) continue;
                    Vector3 l1 = this.vec((int)(i - 1)).vec.copy().subtract(this.vec((int)i).vec).normalize();
                    Vector3 l2 = this.vec((int)(i + 2)).vec.copy().subtract(this.vec((int)(i + 1)).vec).normalize();
                    Vector3 l3 = other.vec((int)j).vec.copy().subtract(other.vec((int)(j + 1)).vec).normalize();
                    Vector3 l4 = other.vec((int)(j - 1)).vec.copy().subtract(other.vec((int)(j - 2)).vec).normalize();
                    if (!l1.equalsT(l3) || !l2.equalsT(l4)) continue;
                    this.setVec(i, other.vec(j + 1));
                    this.setVec(i + 1, other.vec(j - 2));
                    return true;
                }
            }
            return false;
        }
    }
}

