/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.configuration;

import codechicken.lib.configuration.IConfigTag;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.internal.network.PacketDispatcher;
import codechicken.lib.packet.PacketCustom;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="codechickenlib")
public class ConfigSyncManager {
    private static final Logger logger = LogManager.getLogger((String)"CodeChickenLib-ConfigSync");
    private static Map<String, IConfigTag<IConfigTag>> syncMap = new HashMap<String, IConfigTag<IConfigTag>>();
    private static Map<String, SyncState> clientRollbackMap = new HashMap<String, SyncState>();

    public static void registerSync(String modId, IConfigTag tag) {
        syncMap.put(modId, tag);
    }

    public static void handshakeReceived(NetHandlerPlayServer netHandler) {
        if (syncMap.isEmpty()) {
            logger.info("Skipping config sync, No mods have registered a syncable config.");
            return;
        }
        PacketCustom packet = new PacketCustom(PacketDispatcher.NET_CHANNEL, 20);
        packet.writeVarInt(syncMap.size());
        for (Map.Entry<String, IConfigTag<IConfigTag>> entry : syncMap.entrySet()) {
            packet.writeString(entry.getKey());
            SyncState.create(entry.getValue()).write(packet);
        }
        String mods = Joiner.on((String)", ").join(syncMap.keySet());
        logger.info("Sending config sync packet to player. Mods: " + mods);
        netHandler.func_147359_a((Packet)packet.toPacket());
    }

    public static void readSyncPacket(PacketCustom packet) {
        int numStates = packet.readVarInt();
        for (int i = 0; i < numStates; ++i) {
            String ident = packet.readString();
            logger.log(Level.INFO, "Applying config sync for {}.", (Object)ident);
            IConfigTag<IConfigTag> found = syncMap.get(ident);
            SyncState state = SyncState.create((IConfigTag)found.copy());
            clientRollbackMap.put(ident, state);
            SyncState.applyTo(packet, found);
        }
    }

    @SubscribeEvent
    public static void onClientDisconnected(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        for (Map.Entry<String, SyncState> entry : clientRollbackMap.entrySet()) {
            logger.log(Level.INFO, "Client disconnect, rolling back config for {}.", (Object)entry.getKey());
            entry.getValue().revert(syncMap.get(entry.getKey()));
        }
        clientRollbackMap.clear();
    }

    public static class SyncState {
        public List<IConfigTag<IConfigTag>> syncTags = new ArrayList<IConfigTag<IConfigTag>>();

        public static SyncState create(IConfigTag<IConfigTag> tag) {
            SyncState state = new SyncState();
            tag.walkTags(e -> {
                if (!e.isCategory() && e.requiresSync()) {
                    state.syncTags.add((IConfigTag<IConfigTag>)e);
                }
            });
            return state;
        }

        public static void applyTo(MCDataInput in, IConfigTag<IConfigTag> parent) {
            SyncState master = SyncState.create(parent);
            HashMap<String, IConfigTag<IConfigTag>> lookup = new HashMap<String, IConfigTag<IConfigTag>>();
            for (IConfigTag<IConfigTag> tag : master.syncTags) {
                lookup.put(tag.getUnlocalizedName(), tag);
            }
            int numTags = in.readVarInt();
            for (int i = 0; i < numTags; ++i) {
                String ident = in.readString();
                IConfigTag found = (IConfigTag)lookup.get(ident);
                if (found == null) {
                    throw new RuntimeException("Unable to apply server sync, tag does not exist! " + ident);
                }
                found.read(in);
            }
            try {
                parent.runSync(IConfigTag.SyncType.CONNECT);
            }
            catch (IConfigTag.SyncException e) {
                throw new RuntimeException("Unable to apply server sync, SyncException thrown!", e);
            }
        }

        public void revert(IConfigTag<IConfigTag> parent) {
            SyncState master = SyncState.create(parent);
            HashMap<String, IConfigTag<IConfigTag>> lookup = new HashMap<String, IConfigTag<IConfigTag>>();
            for (IConfigTag<IConfigTag> tag : master.syncTags) {
                lookup.put(tag.getUnlocalizedName(), tag);
            }
            for (IConfigTag<IConfigTag> tag : this.syncTags) {
                IConfigTag found = (IConfigTag)lookup.get(tag.getUnlocalizedName());
                if (found == null) {
                    throw new RuntimeException("Unable to revert config state, tag no longer exists.. " + tag.getUnlocalizedName());
                }
                found.copyFrom(tag);
            }
            try {
                parent.runSync(IConfigTag.SyncType.DISCONNECT);
            }
            catch (IConfigTag.SyncException e) {
                throw new RuntimeException("Unable to revert server sync, SyncException thrown!", e);
            }
        }

        public void write(MCDataOutput out) {
            out.writeVarInt(this.syncTags.size());
            for (IConfigTag<IConfigTag> tag : this.syncTags) {
                out.writeString(tag.getUnlocalizedName());
                tag.write(out);
            }
        }
    }
}

