/*
 * Decompiled with CFR 0.152.
 */
package xt9.inworldcrafting.integrations.jei;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import xt9.inworldcrafting.common.recipe.BurnItemRecipe;
import xt9.inworldcrafting.common.recipe.ExplodeBlockRecipe;
import xt9.inworldcrafting.common.recipe.ExplodeItemRecipe;
import xt9.inworldcrafting.common.recipe.FluidToFluidRecipe;
import xt9.inworldcrafting.common.recipe.FluidToItemRecipe;
import xt9.inworldcrafting.integrations.jei.BurnItemRecipeCategory;
import xt9.inworldcrafting.integrations.jei.BurnItemRecipeWrapper;
import xt9.inworldcrafting.integrations.jei.ExplodeBlockRecipeCategory;
import xt9.inworldcrafting.integrations.jei.ExplodeBlockRecipeWrapper;
import xt9.inworldcrafting.integrations.jei.ExplodeItemRecipeCategory;
import xt9.inworldcrafting.integrations.jei.ExplodeItemRecipeWrapper;
import xt9.inworldcrafting.integrations.jei.FluidToFluidRecipeCategory;
import xt9.inworldcrafting.integrations.jei.FluidToFluidRecipeWrapper;
import xt9.inworldcrafting.integrations.jei.FluidToItemRecipeCategory;
import xt9.inworldcrafting.integrations.jei.FluidToItemRecipeWrapper;

@JEIPlugin
public class Plugin
implements IModPlugin {
    private static IJeiHelpers jeiHelpers;
    private static FluidToFluidRecipeCategory fluidCategory;
    private static FluidToItemRecipeCategory itemCategory;
    private static ExplodeItemRecipeCategory explodeItemCategory;
    private static ExplodeBlockRecipeCategory explodeBlockCategory;
    private static BurnItemRecipeCategory burnItemCategory;

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        fluidCategory = new FluidToFluidRecipeCategory(guiHelper);
        registry.addRecipeCategories(new IRecipeCategory[]{fluidCategory});
        itemCategory = new FluidToItemRecipeCategory(guiHelper);
        registry.addRecipeCategories(new IRecipeCategory[]{itemCategory});
        explodeItemCategory = new ExplodeItemRecipeCategory(guiHelper);
        registry.addRecipeCategories(new IRecipeCategory[]{explodeItemCategory});
        explodeBlockCategory = new ExplodeBlockRecipeCategory(guiHelper);
        registry.addRecipeCategories(new IRecipeCategory[]{explodeBlockCategory});
        burnItemCategory = new BurnItemRecipeCategory(guiHelper);
        registry.addRecipeCategories(new IRecipeCategory[]{burnItemCategory});
    }

    public void register(IModRegistry registry) {
        jeiHelpers = registry.getJeiHelpers();
        registry.handleRecipes(FluidToFluidRecipe.class, FluidToFluidRecipeWrapper::new, fluidCategory.getUid());
        this.addFluidToFluidRecipes(registry);
        registry.handleRecipes(FluidToItemRecipe.class, FluidToItemRecipeWrapper::new, itemCategory.getUid());
        this.addFluidToItemRecipes(registry);
        registry.handleRecipes(ExplodeItemRecipe.class, ExplodeItemRecipeWrapper::new, explodeItemCategory.getUid());
        this.addExplodeItemRecipes(registry);
        registry.handleRecipes(ExplodeBlockRecipe.class, ExplodeBlockRecipeWrapper::new, explodeBlockCategory.getUid());
        this.addExplodeBlocksRecipes(registry);
        registry.handleRecipes(BurnItemRecipe.class, BurnItemRecipeWrapper::new, burnItemCategory.getUid());
        this.addBurnItemRecipes(registry);
    }

    private void addBurnItemRecipes(IModRegistry registry) {
        registry.addRecipes(BurnItemRecipe.recipes, burnItemCategory.getUid());
        registry.addRecipeCatalyst((Object)new ItemStack(Items.field_151033_d), new String[]{burnItemCategory.getUid()});
    }

    private void addExplodeBlocksRecipes(IModRegistry registry) {
        registry.addRecipes(ExplodeBlockRecipe.recipes, explodeBlockCategory.getUid());
        registry.addRecipeCatalyst((Object)new ItemStack(Blocks.field_150335_W), new String[]{explodeBlockCategory.getUid()});
        ItemStack creeperSkull = new ItemStack(Items.field_151144_bL);
        creeperSkull.func_77964_b(4);
        registry.addRecipeCatalyst((Object)creeperSkull, new String[]{explodeBlockCategory.getUid()});
    }

    private void addExplodeItemRecipes(IModRegistry registry) {
        registry.addRecipes(ExplodeItemRecipe.recipes, explodeItemCategory.getUid());
        registry.addRecipeCatalyst((Object)new ItemStack(Blocks.field_150335_W), new String[]{explodeItemCategory.getUid()});
        ItemStack creeperSkull = new ItemStack(Items.field_151144_bL);
        creeperSkull.func_77964_b(4);
        registry.addRecipeCatalyst((Object)creeperSkull, new String[]{explodeItemCategory.getUid()});
    }

    private void addFluidToFluidRecipes(IModRegistry registry) {
        registry.addRecipes(FluidToFluidRecipe.recipes, fluidCategory.getUid());
    }

    private void addFluidToItemRecipes(IModRegistry registry) {
        registry.addRecipes(FluidToItemRecipe.recipes, itemCategory.getUid());
    }
}

