/*
 * Decompiled with CFR 0.152.
 */
package xt9.inworldcrafting.common.event;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import xt9.inworldcrafting.common.crafting.CraftingItem;
import xt9.inworldcrafting.common.recipe.BurnItemRecipe;
import xt9.inworldcrafting.common.recipe.FluidToFluidRecipe;
import xt9.inworldcrafting.common.recipe.FluidToItemRecipe;

@Mod.EventBusSubscriber
public class EntityMatcher {
    public static NonNullList<IIngredient> allValidInputs = NonNullList.func_191196_a();

    @SubscribeEvent
    public static void itemSpawnInWorld(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof EntityItem)) {
            return;
        }
        if (!event.getWorld().field_72995_K) {
            EntityItem entity = (EntityItem)event.getEntity();
            ItemStack spawnedStack = ((EntityItem)event.getEntity()).func_92059_d();
            boolean match = false;
            for (IIngredient input : allValidInputs) {
                if (!input.amount(1).matches(CraftTweakerMC.getIItemStack((ItemStack)spawnedStack))) continue;
                match = true;
            }
            if (!match) {
                return;
            }
            CraftingItem craftingItem = new CraftingItem(new NBTTagCompound());
            EntityMatcher.matchFluidToFluidRecipes(spawnedStack, craftingItem);
            EntityMatcher.matchFluidToItemRecipes(spawnedStack, craftingItem);
            EntityMatcher.matchBurnItemRecipes(spawnedStack, craftingItem);
            if (craftingItem.containsRecipes()) {
                entity.func_174867_a(15);
                entity.func_184224_h(true);
                entity.getEntityData().func_74782_a(CraftingItem.getNbtKey(), (NBTBase)craftingItem.serialize());
            }
        }
    }

    private static void matchFluidToFluidRecipes(ItemStack spawnedStack, CraftingItem craftingItem) {
        block0: for (int i = 0; i < FluidToFluidRecipe.recipes.size(); ++i) {
            IIngredient[] ingredients = FluidToFluidRecipe.recipes.get(i).getInputs();
            for (int j = 0; j < ingredients.length; ++j) {
                if (!ingredients[j].amount(1).matches(CraftTweakerMC.getIItemStack((ItemStack)spawnedStack))) continue;
                craftingItem.addFluidToFluidRecipeIndex(i);
                continue block0;
            }
        }
    }

    private static void matchFluidToItemRecipes(ItemStack spawnedStack, CraftingItem craftingItem) {
        block0: for (int i = 0; i < FluidToItemRecipe.recipes.size(); ++i) {
            IIngredient[] ingredients = FluidToItemRecipe.recipes.get(i).getInputs();
            for (int j = 0; j < ingredients.length; ++j) {
                if (!ingredients[j].amount(1).matches(CraftTweakerMC.getIItemStack((ItemStack)spawnedStack))) continue;
                craftingItem.addFluidToItemRecipeIndex(i);
                continue block0;
            }
        }
    }

    private static void matchBurnItemRecipes(ItemStack spawnedStack, CraftingItem craftingItem) {
        for (int i = 0; i < BurnItemRecipe.recipes.size(); ++i) {
            if (!BurnItemRecipe.recipes.get(i).getInputs().matches(CraftTweakerMC.getIItemStack((ItemStack)spawnedStack))) continue;
            craftingItem.setBurnItemRecipe(i);
        }
    }
}

