/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.util.helper;

import WayofTime.bloodmagic.core.data.BMWorldSavedData;
import WayofTime.bloodmagic.core.data.Binding;
import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.core.registry.OrbRegistry;
import WayofTime.bloodmagic.event.SoulNetworkEvent;
import WayofTime.bloodmagic.iface.IBindable;
import WayofTime.bloodmagic.orb.BloodOrb;
import WayofTime.bloodmagic.orb.IBloodOrb;
import WayofTime.bloodmagic.util.helper.PlayerHelper;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class NetworkHelper {
    public static SoulNetwork getSoulNetwork(String uuid) {
        WorldServer world = DimensionManager.getWorld((int)0);
        if (world == null || world.func_175693_T() == null) {
            return new BMWorldSavedData().getNetwork(UUID.fromString(uuid));
        }
        BMWorldSavedData saveData = (BMWorldSavedData)world.func_175693_T().func_75742_a(BMWorldSavedData.class, "BloodMagic-SoulNetworks");
        if (saveData == null) {
            saveData = new BMWorldSavedData();
            world.func_175693_T().func_75745_a("BloodMagic-SoulNetworks", (WorldSavedData)saveData);
        }
        return saveData.getNetwork(UUID.fromString(uuid));
    }

    public static SoulNetwork getSoulNetwork(UUID uuid) {
        return NetworkHelper.getSoulNetwork(uuid.toString());
    }

    public static SoulNetwork getSoulNetwork(EntityPlayer player) {
        return NetworkHelper.getSoulNetwork(PlayerHelper.getUUIDFromPlayer(player));
    }

    public static SoulNetwork getSoulNetwork(Binding binding) {
        return NetworkHelper.getSoulNetwork(binding.getOwnerId());
    }

    public static int getCurrentMaxOrb(SoulNetwork soulNetwork) {
        return soulNetwork.getOrbTier();
    }

    public static int getMaximumForTier(int tier) {
        int ret = 0;
        if (tier > OrbRegistry.getTierMap().size() || tier < 0) {
            return ret;
        }
        for (ItemStack orbStack : OrbRegistry.getOrbsForTier(tier)) {
            BloodOrb orb = ((IBloodOrb)orbStack.func_77973_b()).getOrb(orbStack);
            if (orb.getCapacity() <= ret) continue;
            ret = orb.getCapacity();
        }
        return ret;
    }

    @Deprecated
    public static boolean syphonAndDamage(SoulNetwork soulNetwork, EntityPlayer user, int toSyphon) {
        return soulNetwork.syphonAndDamage(user, toSyphon);
    }

    public static boolean syphonFromContainer(ItemStack stack, SoulTicket ticket) {
        if (!(stack.func_77973_b() instanceof IBindable)) {
            return false;
        }
        Binding binding = ((IBindable)stack.func_77973_b()).getBinding(stack);
        if (binding == null) {
            return false;
        }
        SoulNetwork network = NetworkHelper.getSoulNetwork(binding);
        SoulNetworkEvent.Syphon.Item event = new SoulNetworkEvent.Syphon.Item(network, ticket, stack);
        return !MinecraftForge.EVENT_BUS.post((Event)event) && network.syphon(event.getTicket(), true) >= ticket.getAmount();
    }

    public static boolean canSyphonFromContainer(ItemStack stack, int toSyphon) {
        if (!(stack.func_77973_b() instanceof IBindable)) {
            return false;
        }
        Binding binding = ((IBindable)stack.func_77973_b()).getBinding(stack);
        if (binding == null) {
            return false;
        }
        SoulNetwork network = NetworkHelper.getSoulNetwork(binding);
        return network.getCurrentEssence() >= toSyphon;
    }

    public static void setMaxOrb(SoulNetwork soulNetwork, int maxOrb) {
        soulNetwork.setOrbTier(Math.max(maxOrb, soulNetwork.getOrbTier()));
    }
}

