/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.block.base;

import WayofTime.bloodmagic.block.base.BlockEnum;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEnumWall<E extends Enum<E>>
extends BlockEnum<E> {
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    protected static final AxisAlignedBB[] AABB_BY_INDEX = new AxisAlignedBB[]{new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.25, 0.75, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 1.0, 0.75), new AxisAlignedBB(0.3125, 0.0, 0.0, 0.6875, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.25, 1.0, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.25, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.3125, 1.0, 0.875, 0.6875), new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    protected static final AxisAlignedBB[] CLIP_AABB_BY_INDEX = new AxisAlignedBB[]{AABB_BY_INDEX[0].func_186666_e(1.5), AABB_BY_INDEX[1].func_186666_e(1.5), AABB_BY_INDEX[2].func_186666_e(1.5), AABB_BY_INDEX[3].func_186666_e(1.5), AABB_BY_INDEX[4].func_186666_e(1.5), AABB_BY_INDEX[5].func_186666_e(1.5), AABB_BY_INDEX[6].func_186666_e(1.5), AABB_BY_INDEX[7].func_186666_e(1.5), AABB_BY_INDEX[8].func_186666_e(1.5), AABB_BY_INDEX[9].func_186666_e(1.5), AABB_BY_INDEX[10].func_186666_e(1.5), AABB_BY_INDEX[11].func_186666_e(1.5), AABB_BY_INDEX[12].func_186666_e(1.5), AABB_BY_INDEX[13].func_186666_e(1.5), AABB_BY_INDEX[14].func_186666_e(1.5), AABB_BY_INDEX[15].func_186666_e(1.5)};

    public BlockEnumWall(Material material, Class<E> enumClass, String propName) {
        super(material, enumClass, propName);
    }

    public BlockEnumWall(Material material, Class<E> enumClass) {
        this(material, enumClass, "type");
    }

    @Override
    protected BlockStateContainer createStateContainer() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{this.getProperty(), UP, NORTH, EAST, SOUTH, WEST}).build();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        return AABB_BY_INDEX[BlockEnumWall.getAABBIndex(state)];
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        blockState = blockState.func_185899_b(worldIn, pos);
        return CLIP_AABB_BY_INDEX[BlockEnumWall.getAABBIndex(blockState)];
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    private boolean canConnectTo(IBlockAccess worldIn, BlockPos pos) {
        IBlockState worldState = worldIn.func_180495_p(pos);
        Block block = worldState.func_177230_c();
        return block != Blocks.field_180401_cv && (block == this || block instanceof BlockFenceGate || worldState.func_185904_a().func_76218_k() && worldState.func_185917_h() && worldState.func_185904_a() != Material.field_151572_C);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.DOWN || super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean canNorth = this.canConnectTo(worldIn, pos.func_177978_c());
        boolean canEast = this.canConnectTo(worldIn, pos.func_177974_f());
        boolean canSouth = this.canConnectTo(worldIn, pos.func_177968_d());
        boolean canWest = this.canConnectTo(worldIn, pos.func_177976_e());
        boolean flag4 = canNorth && !canEast && canSouth && !canWest || !canNorth && canEast && !canSouth && canWest;
        return state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(!flag4 || !worldIn.func_175623_d(pos.func_177984_a()))).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(canNorth)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(canEast)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(canSouth)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(canWest));
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack((Block)this, 1, this.func_180651_a(state));
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return super.func_176201_c(state);
    }

    private static int getAABBIndex(IBlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            i |= 1 << EnumFacing.NORTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            i |= 1 << EnumFacing.EAST.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            i |= 1 << EnumFacing.SOUTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            i |= 1 << EnumFacing.WEST.func_176736_b();
        }
        return i;
    }
}

