/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla.capability.recipehandler;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreIngredient;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.helper.CraftingHelpers;

public class VanillaCraftingTableRecipeHandler
implements IRecipeHandler {
    private static final Set<IngredientComponent<?, ?>> COMPONENTS_INPUT = Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK});
    private static final Set<IngredientComponent<?, ?>> COMPONENTS_OUTPUT = Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK});
    public static final Container DUMMY_CONTAINTER = new Container(){

        public boolean func_75145_c(EntityPlayer playerIn) {
            return true;
        }
    };
    private final World world;

    public VanillaCraftingTableRecipeHandler(World world) {
        this.world = world;
    }

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeInputComponents() {
        return COMPONENTS_INPUT;
    }

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeOutputComponents() {
        return COMPONENTS_OUTPUT;
    }

    public boolean isValidSizeInput(IngredientComponent component, int size) {
        return component == IngredientComponent.ITEMSTACK && size > 0;
    }

    public static List<IPrototypedIngredient<ItemStack, Integer>> getPrototypesFromIngredient(Ingredient ingredient) {
        if (ingredient instanceof IngredientNBT) {
            return Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, ingredient.func_193365_a()[0], 7)});
        }
        if (ingredient instanceof OreIngredient) {
            return Arrays.stream(ingredient.func_193365_a()).map(itemStack -> new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, (ItemStack)itemStack, 3)).collect(Collectors.toList());
        }
        return Arrays.stream(ingredient.func_193365_a()).map(itemStack -> new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, (ItemStack)itemStack, 3)).collect(Collectors.toList());
    }

    public static IRecipeDefinition recipeToRecipeDefinition(IRecipe recipe) {
        ArrayList inputIngredients = Lists.newArrayListWithCapacity((int)recipe.func_192400_c().size());
        for (int i = 0; i < recipe.func_192400_c().size(); ++i) {
            Ingredient ingredient = (Ingredient)recipe.func_192400_c().get(i);
            List<IPrototypedIngredient<ItemStack, Integer>> prototypes = VanillaCraftingTableRecipeHandler.getPrototypesFromIngredient(ingredient);
            if (prototypes.isEmpty()) {
                prototypes.add(new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, ItemStack.field_190927_a, 3));
            }
            inputIngredients.add(i, prototypes);
        }
        return RecipeDefinition.ofIngredients(IngredientComponent.ITEMSTACK, inputIngredients, MixedIngredients.ofInstance(IngredientComponent.ITEMSTACK, recipe.func_77571_b()));
    }

    @Override
    public Collection<IRecipeDefinition> getRecipes() {
        return Collections2.transform((Collection)ForgeRegistries.RECIPES.getValuesCollection(), (Function)new Function<IRecipe, IRecipeDefinition>(){

            @Nullable
            public IRecipeDefinition apply(@Nullable IRecipe input) {
                return VanillaCraftingTableRecipeHandler.recipeToRecipeDefinition(input);
            }
        });
    }

    @Override
    @Nullable
    public IMixedIngredients simulate(IMixedIngredients input) {
        List<ItemStack> recipeIngredients = input.getInstances(IngredientComponent.ITEMSTACK);
        if (input.getComponents().size() != 1 || recipeIngredients.size() < 1) {
            return null;
        }
        InventoryCrafting inventoryCrafting = new InventoryCrafting(DUMMY_CONTAINTER, 3, 3);
        for (int i = 0; i < recipeIngredients.size(); ++i) {
            inventoryCrafting.func_70299_a(i, recipeIngredients.get(i));
        }
        IRecipe recipe = CraftingHelpers.findMatchingRecipeCached((InventoryCrafting)inventoryCrafting, (World)this.world, (boolean)true);
        if (recipe == null) {
            return null;
        }
        return MixedIngredients.ofInstance(IngredientComponent.ITEMSTACK, recipe.func_77571_b());
    }
}

