/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.forestry.capability.recipehandler;

import forestry.api.recipes.ICraftingProvider;
import forestry.api.recipes.IForestryRecipe;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;

public abstract class CraftingProviderRecipeHandlerAdapter<R extends IForestryRecipe>
implements IRecipeHandler {
    private final ICraftingProvider<R> craftingProvider;
    private final Set<IngredientComponent<?, ?>> inputComponents;
    private final Set<IngredientComponent<?, ?>> outputComponents;
    private final Collection<IRecipeDefinition> recipes;

    public CraftingProviderRecipeHandlerAdapter(ICraftingProvider<R> craftingProvider, Set<IngredientComponent<?, ?>> inputComponents, Set<IngredientComponent<?, ?>> outputComponents) {
        this.craftingProvider = craftingProvider;
        this.inputComponents = inputComponents;
        this.outputComponents = outputComponents;
        this.recipes = this.craftingProvider.recipes().stream().map(this::transformRecipe).collect(Collectors.toList());
    }

    public ICraftingProvider<R> getCraftingProvider() {
        return this.craftingProvider;
    }

    protected abstract IRecipeDefinition transformRecipe(R var1);

    protected abstract R findRecipe(IMixedIngredients var1);

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeInputComponents() {
        return this.inputComponents;
    }

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeOutputComponents() {
        return this.outputComponents;
    }

    @Override
    public Collection<IRecipeDefinition> getRecipes() {
        return this.recipes;
    }

    @Override
    @Nullable
    public IMixedIngredients simulate(IMixedIngredients input) {
        R forestryRecipe = this.findRecipe(input);
        return forestryRecipe == null ? null : this.transformRecipe(forestryRecipe).getOutput();
    }
}

