/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.ingredient;

import java.util.Objects;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;

public class PrototypedIngredient<T, M>
implements IPrototypedIngredient<T, M> {
    private final IngredientComponent<T, M> ingredientComponent;
    private final T prototype;
    private final M condition;

    public PrototypedIngredient(IngredientComponent<T, M> ingredientComponent, T prototype, M condition) {
        this.ingredientComponent = ingredientComponent;
        this.prototype = prototype;
        this.condition = condition;
    }

    @Override
    public IngredientComponent<T, M> getComponent() {
        return this.ingredientComponent;
    }

    @Override
    public T getPrototype() {
        return this.prototype;
    }

    @Override
    public M getCondition() {
        return this.condition;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IPrototypedIngredient) {
            IPrototypedIngredient that = (IPrototypedIngredient)obj;
            return this.getComponent().equals(that.getComponent()) && this.getComponent().getMatcher().matchesExactly(this.getPrototype(), that.getPrototype()) && Objects.equals(this.getCondition(), that.getCondition());
        }
        return false;
    }

    public int hashCode() {
        return 0x18A | this.getComponent().hashCode() << 4 | this.getComponent().getMatcher().hash(this.getPrototype()) << 2 | this.getCondition().hashCode();
    }

    public String toString() {
        return "[PrototypedIngredient ingredientComponent: " + this.ingredientComponent.toString() + "; prototype: " + Objects.toString(this.prototype) + "; condition: " + Objects.toString(this.condition) + "]";
    }

    @Override
    public int compareTo(IPrototypedIngredient<?, ?> that) {
        int compComp = this.getComponent().compareTo(that.getComponent());
        if (compComp != 0) {
            return compComp;
        }
        IIngredientMatcher<T, M> matcher = this.getComponent().getMatcher();
        int compProt = matcher.compare(this.getPrototype(), that.getPrototype());
        if (compProt != 0) {
            return compProt;
        }
        return matcher.conditionCompare(this.getCondition(), that.getCondition());
    }
}

