/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.recipehandler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;

public class RecipeDefinition
implements IRecipeDefinition {
    private final Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> inputs;
    private final IMixedIngredients output;

    public RecipeDefinition(Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> inputs, IMixedIngredients output) {
        this.inputs = inputs;
        this.output = output;
    }

    @Override
    public Set<IngredientComponent<?, ?>> getInputComponents() {
        return this.inputs.keySet();
    }

    @Override
    public <T, M> List<IPrototypedIngredientAlternatives<T, M>> getInputs(IngredientComponent<T, M> ingredientComponent) {
        return this.inputs.getOrDefault(ingredientComponent, Collections.emptyList());
    }

    @Override
    public IMixedIngredients getOutput() {
        return this.output;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IRecipeDefinition) {
            IRecipeDefinition that = (IRecipeDefinition)obj;
            if (Sets.newHashSet(this.getInputComponents()).equals(Sets.newHashSet(that.getInputComponents())) && this.getOutput().equals(that.getOutput())) {
                for (IngredientComponent<?, ?> component : this.getInputComponents()) {
                    if (this.getInputs(component).equals(that.getInputs(component))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int inputsHash = 333;
        for (List<IPrototypedIngredientAlternatives<?, ?>> values : this.inputs.values()) {
            inputsHash |= values.hashCode();
        }
        return 0x242 | inputsHash << 2 | this.output.hashCode();
    }

    public String toString() {
        return "[RecipeDefinition input: " + this.inputs.toString() + "; output: " + this.output.toString() + "]";
    }

    public static <T, R, M> RecipeDefinition ofAlternatives(IngredientComponent<T, M> component, List<IPrototypedIngredientAlternatives<T, M>> alternatives, IMixedIngredients output) {
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        inputs.put(component, alternatives);
        return new RecipeDefinition(inputs, output);
    }

    public static <T, R, M> RecipeDefinition ofIngredients(IngredientComponent<T, M> component, List<List<IPrototypedIngredient<T, M>>> ingredients, IMixedIngredients output) {
        return RecipeDefinition.ofAlternatives(component, ingredients.stream().map(PrototypedIngredientAlternativesList::new).collect(Collectors.toList()), output);
    }

    public static <T, R, M> RecipeDefinition ofIngredient(IngredientComponent<T, M> component, List<IPrototypedIngredient<T, M>> ingredient, IMixedIngredients output) {
        ArrayList ingredients = Lists.newArrayList();
        ingredients.add(ingredient);
        return RecipeDefinition.ofIngredients(component, ingredients, output);
    }

    @Override
    public int compareTo(IRecipeDefinition that) {
        int compOutput = this.getOutput().compareTo(that.getOutput());
        if (compOutput != 0) {
            return compOutput;
        }
        int compComp = MixedIngredients.compareCollection(this.getInputComponents(), that.getInputComponents());
        if (compComp != 0) {
            return compComp;
        }
        for (IngredientComponent<?, ?> component : this.getInputComponents()) {
            List<IPrototypedIngredientAlternatives<?, ?>> thisInputs = this.getInputs(component);
            List<IPrototypedIngredientAlternatives<?, ?>> thatInputs = that.getInputs(component);
            if (thisInputs.size() != thatInputs.size()) {
                return thisInputs.size() - thatInputs.size();
            }
            Object[] aArray = thisInputs.toArray();
            Object[] bArray = thatInputs.toArray();
            for (int i = 0; i < aArray.length; ++i) {
                int compCol = MixedIngredients.compareCollection(((IPrototypedIngredientAlternatives)aArray[i]).getAlternatives(), ((IPrototypedIngredientAlternatives)bArray[i]).getAlternatives());
                if (compCol == 0) continue;
                return compCol;
            }
        }
        return 0;
    }
}

