/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.events;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticalworld.capability.PlayerShoulderCapability;
import epicsquid.mysticalworld.capability.PlayerShoulderCapabilityProvider;
import epicsquid.mysticalworld.network.MessagePlayerShoulderUpdate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber(modid="mysticalworld")
public class ShoulderHandler {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Entity animal;
        PlayerShoulderCapability cap;
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        if (!world.field_72995_K && event.getHand() == EnumHand.MAIN_HAND && player.func_70093_af() && (cap = (PlayerShoulderCapability)player.getCapability(PlayerShoulderCapabilityProvider.PLAYER_SHOULDER_CAPABILITY, null)) != null && cap.isShouldered() && (animal = EntityList.func_188429_b((ResourceLocation)cap.getRegistryName(), (World)world)) != null) {
            animal.func_70020_e(cap.getAnimalSerialized());
            BlockPos pos = event.getPos();
            animal.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5);
            world.func_72838_d(animal);
            player.func_184609_a(EnumHand.MAIN_HAND);
            cap.drop();
            event.setCanceled(true);
            if (!world.field_72995_K) {
                MessagePlayerShoulderUpdate message = new MessagePlayerShoulderUpdate(player, cap);
                PacketHandler.sendToAllTracking((IMessage)message, (Entity)player);
            }
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        if (living instanceof EntityPlayer) {
            Entity animal;
            EntityPlayer player = (EntityPlayer)living;
            World world = player.field_70170_p;
            PlayerShoulderCapability cap = (PlayerShoulderCapability)player.getCapability(PlayerShoulderCapabilityProvider.PLAYER_SHOULDER_CAPABILITY, null);
            if (cap != null && cap.isShouldered() && (animal = EntityList.func_188429_b((ResourceLocation)cap.getRegistryName(), (World)world)) != null) {
                animal.func_70020_e(cap.getAnimalSerialized());
                BlockPos pos = player.func_180425_c();
                animal.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5);
                world.func_72838_d(animal);
                cap.drop();
                if (!world.field_72995_K) {
                    MessagePlayerShoulderUpdate message = new MessagePlayerShoulderUpdate(player, cap);
                    PacketHandler.sendToAllTracking((IMessage)message, (Entity)player);
                }
            }
        }
    }
}

