/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.table;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.crafting.table.TableRecipeBase;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class TableRecipeShapeless
extends TableRecipeBase {
    protected final ItemStack output;
    protected final NonNullList<Ingredient> input = NonNullList.func_191196_a();
    protected final ResourceLocation group;
    protected final int tier;
    protected Map<Integer, Function<ItemStack, ItemStack>> transformers;
    public int enderCrafterRecipeTimeRequired = ModConfig.confEnderTimeRequired;

    public TableRecipeShapeless(int tier, ItemStack result, NonNullList<Ingredient> recipe) {
        super(tier, result, recipe);
        this.group = RecipeHelper.EMPTY_GROUP;
        this.tier = tier;
        this.output = result.func_77946_l();
        for (Ingredient i : recipe) {
            if (i == null) {
                StringBuilder ret = new StringBuilder("Invalid shapeless ore recipe: ");
                for (Object tmp : recipe) {
                    ret.append(tmp).append(", ");
                }
                ret.append(this.output);
                throw new IllegalArgumentException(ret.toString());
            }
            this.input.add((Object)i);
        }
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        LinkedList<Ingredient> required = new LinkedList<Ingredient>((Collection<Ingredient>)this.input);
        if (this.tier != 0 && this.tier != this.getTierFromSize(inv.func_70302_i_())) {
            return false;
        }
        block0: for (int x = 0; x < inv.func_70302_i_(); ++x) {
            ItemStack slot = inv.func_70301_a(x);
            if (slot.func_190926_b()) continue;
            Iterator req = required.iterator();
            while (req.hasNext()) {
                Ingredient target = (Ingredient)req.next();
                if (!target.apply(slot)) continue;
                req.remove();
                continue block0;
            }
            return false;
        }
        return required.isEmpty();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.input.size();
    }

    @Override
    public int getTier() {
        if (this.tier > 0) {
            return this.tier;
        }
        return this.input.size() < 10 ? 1 : (this.input.size() < 26 ? 2 : (this.input.size() < 50 ? 3 : 4));
    }

    public TableRecipeShapeless withTransforms(Map<Integer, Function<ItemStack, ItemStack>> transformers) {
        this.transformers = transformers;
        return this;
    }
}

