/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.crafttweaker;

import com.blakebr0.extendedcrafting.compat.crafttweaker.CraftTweakerUtils;
import com.blakebr0.extendedcrafting.crafting.CompressorRecipe;
import com.blakebr0.extendedcrafting.crafting.CompressorRecipeManager;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.extendedcrafting.CompressionCrafting")
public class CompressionCrafting {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, int inputCount, IIngredient catalyst, int powerCost) {
        CraftTweakerAPI.apply((IAction)new Add(new CompressorRecipe(CraftTweakerMC.getItemStack((IItemStack)output), CraftTweakerUtils.toIngredient(input), inputCount, CraftTweakerUtils.toIngredient(catalyst), false, powerCost)));
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, int inputCount, IIngredient catalyst, int powerCost, int powerRate) {
        CraftTweakerAPI.apply((IAction)new Add(new CompressorRecipe(CraftTweakerMC.getItemStack((IItemStack)output), CraftTweakerUtils.toIngredient(input), inputCount, CraftTweakerUtils.toIngredient(catalyst), false, powerCost, powerRate)));
    }

    @ZenMethod
    public static void remove(IItemStack target) {
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerMC.getItemStack((IItemStack)target)));
    }

    private static class Add
    implements IAction {
        final CompressorRecipe recipe;

        public Add(CompressorRecipe add) {
            this.recipe = add;
        }

        public void apply() {
            CompressorRecipeManager.getInstance().getRecipes().add(this.recipe);
        }

        public String describe() {
            return "Adding a Compression Crafting recipe for " + this.recipe.getOutput().func_82833_r();
        }
    }

    private static class Remove
    implements IAction {
        final ItemStack remove;

        public Remove(ItemStack remove) {
            this.remove = remove;
        }

        public void apply() {
            CompressorRecipeManager.getInstance().removeRecipes(this.remove);
        }

        public String describe() {
            return "Removing all Compression Crafting recipes for " + this.remove.func_82833_r();
        }
    }
}

