/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.client.gui.automationinterface;

import com.blakebr0.cucumber.gui.GuiIcons;
import com.blakebr0.cucumber.gui.button.IconButton;
import com.blakebr0.cucumber.helper.ResourceHelper;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.extendedcrafting.client.container.automationinterface.ContainerAutomationInterface;
import com.blakebr0.extendedcrafting.client.gui.automationinterface.GuiInterfaceConfig;
import com.blakebr0.extendedcrafting.client.gui.automationinterface.GuiViewRecipe;
import com.blakebr0.extendedcrafting.lib.ViewRecipeInfo;
import com.blakebr0.extendedcrafting.network.InterfaceRecipeChangePacket;
import com.blakebr0.extendedcrafting.network.NetworkThingy;
import com.blakebr0.extendedcrafting.tile.TileAutomationInterface;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@ParametersAreNonnullByDefault
public class GuiAutomationInterface
extends GuiContainer {
    protected static final ResourceLocation GUI = ResourceHelper.getResource((String)"extendedcrafting", (String)"textures/gui/automation_interface.png");
    protected final TileAutomationInterface tile;
    protected final InventoryPlayer player;
    private GuiButton save;
    private GuiButton clear;
    private GuiButton view;
    private GuiButton config;

    public GuiAutomationInterface(ContainerAutomationInterface container) {
        super((Container)container);
        this.tile = container.tile;
        this.player = container.player;
        this.field_146999_f = 176;
        this.field_147000_g = 193;
    }

    protected int getEnergyBarScaled(int pixels) {
        int i = this.tile.getEnergy().getEnergyStored();
        int j = this.tile.getEnergy().getMaxEnergyStored();
        return (int)(j != 0 && i != 0 ? (long)i * (long)pixels / (long)j : 0L);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.save = this.func_189646_b((GuiButton)new IconButton(0, x + 63, y + 77, 14, 14, 1, 198, Utils.localize((String)"ec.interface.save"), GUI));
        this.clear = this.func_189646_b((GuiButton)new IconButton(1, x + 79, y + 77, 14, 14, 17, 198, Utils.localize((String)"ec.interface.clear"), GUI));
        this.view = this.func_189646_b((GuiButton)new IconButton(5, x + 95, y + 77, 14, 14, 33, 198, Utils.localize((String)"ec.interface.view"), GUI));
        this.config = this.func_189646_b((GuiButton)new IconButton(10, x + 115, y + 75, 16, 16, 53, 196, Utils.localize((String)"ec.interface.config"), GUI));
        this.updateButtons();
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.save) {
            NetworkThingy.THINGY.sendToServer((IMessage)new InterfaceRecipeChangePacket(this.tile.func_174877_v().func_177986_g(), 0));
            this.save.field_146124_l = false;
            this.clear.field_146124_l = true;
            this.view.field_146124_l = true;
        } else if (button == this.clear) {
            NetworkThingy.THINGY.sendToServer((IMessage)new InterfaceRecipeChangePacket(this.tile.func_174877_v().func_177986_g(), 1));
            this.save.field_146124_l = true;
            this.clear.field_146124_l = false;
            this.view.field_146124_l = false;
        } else if (button == this.view) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiViewRecipe(this, this.getViewRecipeInfo(), (int)Math.sqrt(this.tile.getRecipe().getSlots())));
        } else if (button == this.config) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiInterfaceConfig(this));
        }
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        super.func_191948_b(mouseX, mouseY);
        if (mouseX > this.field_147003_i + 7 && mouseX < this.field_147003_i + 20 && mouseY > this.field_147009_r + 16 && mouseY < this.field_147009_r + 93) {
            this.func_146279_a(Utils.format((Object)this.tile.getEnergy().getEnergyStored()) + " FE", mouseX, mouseY);
        }
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof IconButton) || !button.func_146115_a()) continue;
            this.func_146279_a(button.field_146126_j, mouseX, mouseY);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = Utils.localize((String)"container.ec.interface");
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(Utils.localize((String)"container.inventory"), 8, this.field_147000_g - 94, 0x404040);
        GuiIcons.drawCheckOrX((int)63, (int)20, (boolean)this.tile.hasTable());
        this.field_146289_q.func_78276_b(Utils.localize((String)"ec.interface.table"), 79, 23, -1);
        GuiIcons.drawCheckOrX((int)63, (int)36, (boolean)this.tile.hasRecipe());
        this.field_146289_q.func_78276_b(Utils.localize((String)"ec.interface.recipe"), 79, 39, -1);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GUI);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        int i1 = this.getEnergyBarScaled(78);
        this.func_73729_b(x + 7, y + 94 - i1, 178, 78 - i1, 15, i1 + 1);
    }

    public void updateButtons() {
        this.save.field_146124_l = !this.tile.hasRecipe() && this.tile.hasTable();
        this.clear.field_146124_l = this.tile.hasRecipe();
        this.view.field_146124_l = this.tile.hasRecipe();
    }

    private ViewRecipeInfo getViewRecipeInfo() {
        int size = (int)Math.sqrt(this.tile.getRecipe().getSlots());
        switch (size) {
            case 5: {
                return ViewRecipeInfo.ADVANCED;
            }
            case 7: {
                return ViewRecipeInfo.ELITE;
            }
            case 9: {
                return ViewRecipeInfo.ULTIMATE;
            }
        }
        return ViewRecipeInfo.BASIC;
    }
}

