/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.block;

import com.blakebr0.cucumber.block.BlockBase;
import com.blakebr0.cucumber.iface.IModelHelper;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.extendedcrafting.ExtendedCrafting;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockStorage
extends BlockBase
implements IModelHelper {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"variant", Type.class);

    public BlockStorage() {
        super("ec.storage", Material.field_151573_f, SoundType.field_185852_e, 5.0f, 10.0f);
        this.func_149647_a(ExtendedCrafting.CREATIVE_TAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.BLACK_IRON)));
    }

    public void init() {
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return this.func_176201_c(state) == 1 ? SoundType.field_185851_d : SoundType.field_185852_e;
    }

    public Material func_149688_o(IBlockState state) {
        return this.func_176201_c(state) == 1 ? Material.field_151576_e : Material.field_151573_f;
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> stacks) {
        for (Type type : Type.values()) {
            stacks.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
        }
    }

    public void initModels() {
        for (Type type : Type.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)type.getMetadata(), (ModelResourceLocation)new ModelResourceLocation(Objects.requireNonNull(this.getRegistryName()).toString() + "_" + Type.byMetadata(type.getMetadata()).func_176610_l()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.func_77960_j() == 4) {
            tooltip.add("\u00a7o" + Utils.localize((String)"tooltip.ec.ultimate_block"));
        }
    }

    public static enum Type implements IStringSerializable
    {
        BLACK_IRON(0, "black_iron"),
        LUMINESSENCE(1, "luminessence"),
        NETHER_STAR(2, "nether_star"),
        CRYSTALTINE(3, "crystaltine"),
        ULTIMATE(4, "ultimate"),
        ENDER(5, "ender"),
        ENDER_STAR(6, "ender_star"),
        ENHANCED_ENDER(7, "enhanced_ender");

        private static final Type[] META_LOOKUP;
        private final int meta;
        private final String name;

        private Type(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static Type byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new Type[Type.values().length];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type;
                Type.META_LOOKUP[type.getMetadata()] = type = typeArray[i];
            }
        }
    }
}

