/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.structure.tomb;

import com.teammetallurgy.atum.world.ChunkGeneratorAtum;
import com.teammetallurgy.atum.world.gen.structure.tomb.TombPieces;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenTomb
extends MapGenStructure {
    private final ChunkGeneratorAtum chunkGenerator;
    private int seed = 10387666;
    private int spacing = 12;
    private int separation = 10;

    public MapGenTomb(ChunkGeneratorAtum chunkGenerator) {
        this.chunkGenerator = chunkGenerator;
    }

    @Nonnull
    public String func_143025_a() {
        return String.valueOf(TombPieces.TOMB);
    }

    public BlockPos func_180706_b(@Nonnull World world, @Nonnull BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = world;
        return MapGenTomb.func_191069_a((World)world, (MapGenStructure)this, (BlockPos)pos, (int)this.spacing, (int)this.separation, (int)this.seed, (boolean)true, (int)100, (boolean)findUnexplored);
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        int x = chunkX;
        int z = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.spacing - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.spacing - 1;
        }
        int xSpacing = chunkX / this.spacing;
        int zSpacing = chunkZ / this.spacing;
        Random random = this.field_75039_c.func_72843_D(xSpacing, zSpacing, this.seed);
        xSpacing *= this.spacing;
        zSpacing *= this.spacing;
        return x == (xSpacing += (random.nextInt(this.spacing - this.separation) + random.nextInt(this.spacing - this.separation)) / 2) && z == (zSpacing += (random.nextInt(this.spacing - this.separation) + random.nextInt(this.spacing - this.separation)) / 2);
    }

    @Nonnull
    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.chunkGenerator, this.field_75038_b, chunkX, chunkZ);
    }

    public static class Start
    extends StructureStart {
        private boolean isValid;

        public Start() {
        }

        Start(World world, ChunkGeneratorAtum chunkGenerator, Random random, int x, int z) {
            super(x, z);
            this.create(world, chunkGenerator, random, x, z);
        }

        private void create(World world, ChunkGeneratorAtum chunkGenerator, Random random, int chunkX, int chunkZ) {
            Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
            ChunkPrimer chunkPrimer = new ChunkPrimer();
            chunkGenerator.setBlocksInChunk(chunkX, chunkZ, chunkPrimer);
            int y = MathHelper.func_76136_a((Random)random, (int)6, (int)55);
            BlockPos pos = new BlockPos(chunkX * 16 + 8, y, chunkZ * 16 + 8);
            if (y > 60) {
                this.isValid = false;
            } else {
                TombPieces.TombTemplate tomb = new TombPieces.TombTemplate(world.func_72860_G().func_186340_h(), pos, random, rotation);
                this.field_75075_a.add(tomb);
                this.func_75072_c();
                this.isValid = true;
            }
        }

        public void func_75068_a(@Nonnull World world, @Nonnull Random rand, @Nonnull StructureBoundingBox box) {
            super.func_75068_a(world, rand, box);
            int y = this.field_75074_b.field_78895_b;
            for (int x = box.field_78897_a; x <= box.field_78893_d; ++x) {
                block1: for (int z = box.field_78896_c; z <= box.field_78892_f; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (world.func_175623_d(pos) || !this.field_75074_b.func_175898_b((Vec3i)pos)) continue;
                    for (StructureComponent component : this.field_75075_a) {
                        if (!component.func_74874_b().func_175898_b((Vec3i)pos)) continue;
                        component.func_74875_a(world, rand, box);
                        continue block1;
                    }
                }
            }
        }

        public boolean func_75069_d() {
            return this.isValid;
        }
    }
}

