/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.structure.ruins;

import com.teammetallurgy.atum.blocks.wood.BlockAtumPlank;
import com.teammetallurgy.atum.blocks.wood.BlockCrate;
import com.teammetallurgy.atum.blocks.wood.tileentity.crate.TileEntityCrate;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.init.AtumLootTables;
import com.teammetallurgy.atum.world.gen.structure.ruins.MapGenRuin;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponentTemplate;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.registry.EntityEntry;

public class RuinPieces {
    public static final ResourceLocation RUIN = new ResourceLocation("atum", "ruin");

    public static void registerRuins() {
        MapGenStructureIO.func_143034_b(MapGenRuin.Start.class, (String)String.valueOf(RUIN));
        MapGenStructureIO.func_143031_a(RuinTemplate.class, (String)String.valueOf(new ResourceLocation("atum", "ruin_template")));
    }

    public static class RuinTemplate
    extends StructureComponentTemplate {
        private static final List<EntityEntry> BANDITS = Arrays.asList(AtumEntities.BARBARIAN, AtumEntities.BRIGAND, AtumEntities.NOMAD);
        public static final List<EntityEntry> UNDEAD = Arrays.asList(AtumEntities.BONESTORM, AtumEntities.FORSAKEN, AtumEntities.MUMMY, AtumEntities.WRAITH);
        private int ruinType;
        private Rotation rotation;
        private Mirror mirror;

        public RuinTemplate() {
        }

        RuinTemplate(TemplateManager manager, BlockPos pos, Random random, Rotation rotation) {
            this(manager, pos, random, rotation, Mirror.NONE);
        }

        private RuinTemplate(TemplateManager manager, BlockPos pos, Random random, Rotation rotation, Mirror mirror) {
            super(0);
            this.field_186178_c = pos;
            this.rotation = rotation;
            this.mirror = mirror;
            this.ruinType = MathHelper.func_76136_a((Random)random, (int)1, (int)19);
            this.loadTemplate(manager);
        }

        private void loadTemplate(TemplateManager manager) {
            Template template = manager.func_186237_a(null, new ResourceLocation("atum", "ruins/ruin" + this.ruinType));
            PlacementSettings placementsettings = new PlacementSettings().func_186222_a(true).func_186220_a(this.rotation).func_186214_a(this.mirror);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_186175_a(@Nonnull String function, @Nonnull BlockPos pos, @Nonnull World world, @Nonnull Random rand, @Nonnull StructureBoundingBox box) {
            if (function.equals("Spawner")) {
                if (box.func_175898_b((Vec3i)pos)) {
                    world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
                    TileEntity tileEntity = world.func_175625_s(pos);
                    if (tileEntity instanceof TileEntityMobSpawner) {
                        ResourceLocation location = rand.nextDouble() < 0.5 ? BANDITS.get(rand.nextInt(BANDITS.size())).getRegistryName() : UNDEAD.get(rand.nextInt(UNDEAD.size())).getRegistryName();
                        ((TileEntityMobSpawner)tileEntity).func_145881_a().func_190894_a(location);
                    }
                }
            } else if (function.equals("Crate") && box.func_175898_b((Vec3i)pos)) {
                if (rand.nextDouble() <= 0.15) {
                    world.func_180501_a(pos, BlockCrate.getCrate(BlockAtumPlank.WoodType.DEADWOOD).correctFacing(world, pos, BlockCrate.getCrate(BlockAtumPlank.WoodType.DEADWOOD).func_176223_P()), 2);
                    TileEntity tileEntity = world.func_175625_s(pos);
                    if (tileEntity instanceof TileEntityCrate) {
                        ((TileEntityCrate)tileEntity).func_189404_a(AtumLootTables.CRATE, rand.nextLong());
                    }
                } else {
                    world.func_175698_g(pos);
                }
            }
        }

        protected void func_143012_a(NBTTagCompound compound) {
            super.func_143012_a(compound);
            compound.func_74778_a("Rot", this.field_186177_b.func_186215_c().name());
            compound.func_74778_a("Mi", this.field_186177_b.func_186212_b().name());
            compound.func_74768_a("Type", this.ruinType);
        }

        protected void func_143011_b(NBTTagCompound compound, TemplateManager manager) {
            super.func_143011_b(compound, manager);
            this.rotation = Rotation.valueOf((String)compound.func_74779_i("Rot"));
            this.mirror = Mirror.valueOf((String)compound.func_74779_i("Mi"));
            this.ruinType = compound.func_74762_e("Type");
            this.loadTemplate(manager);
        }
    }
}

