/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.utils;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.blocks.base.IRenderMapper;
import com.teammetallurgy.atum.entity.projectile.EntityCamelSpit;
import com.teammetallurgy.atum.init.AtumBiomes;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.proxy.ClientProxy;
import com.teammetallurgy.atum.utils.AtumUtils;
import com.teammetallurgy.atum.utils.Constants;
import com.teammetallurgy.atum.utils.IOreDictEntry;
import com.teammetallurgy.atum.utils.OreDictHelper;
import com.teammetallurgy.atum.world.biome.base.AtumBiome;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="atum")
public class AtumRegistry {
    public static final NonNullList<AtumBiome> BIOMES = NonNullList.func_191196_a();
    private static final NonNullList<EntityEntry> MOBS = NonNullList.func_191196_a();
    private static final NonNullList<EntityEntry> ENTITIES = NonNullList.func_191196_a();
    private static final NonNullList<SoundEvent> SOUNDS = NonNullList.func_191196_a();
    public static final NonNullList<ItemStack> HIDE_LIST = NonNullList.func_191196_a();
    private static HashMap<ResourceLocation, Integer> trackingRange = new HashMap();
    private static HashMap<ResourceLocation, Integer> updateFrequency = new HashMap();
    private static HashMap<ResourceLocation, Boolean> sendsVelocityUpdates = new HashMap();

    public static Item registerItem(@Nonnull Item item, @Nonnull String name, @Nullable String oreDictName) {
        return AtumRegistry.registerItem(item, name, Atum.CREATIVE_TAB, oreDictName);
    }

    public static Item registerItem(@Nonnull Item item, @Nonnull String name) {
        return AtumRegistry.registerItem(item, name, Atum.CREATIVE_TAB, null);
    }

    public static Item registerItem(@Nonnull Item item, @Nonnull String name, @Nullable CreativeTabs tab, @Nullable String oreDictName) {
        item.setRegistryName(new ResourceLocation("atum", AtumUtils.toRegistryName(name)));
        item.func_77655_b("atum." + AtumUtils.toUnlocalizedName(name));
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        if (tab != null) {
            item.func_77637_a(tab);
        } else if (Constants.IS_JEI_LOADED) {
            HIDE_LIST.add((Object)new ItemStack(item));
        }
        if (oreDictName != null) {
            OreDictHelper.add(item, oreDictName);
        }
        if (item instanceof IOreDictEntry) {
            IOreDictEntry entry = (IOreDictEntry)item;
            OreDictHelper.entries.add((Object)entry);
        }
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("atum", AtumUtils.toRegistryName(name)), "inventory"));
        }
        return item;
    }

    public static Block registerBlock(@Nonnull Block block, @Nonnull String name) {
        return AtumRegistry.registerBlock(block, (Item)new ItemBlock(block), name, Atum.CREATIVE_TAB);
    }

    public static Block registerBlock(@Nonnull Block block, @Nonnull String name, @Nullable CreativeTabs tab) {
        return AtumRegistry.registerBlock(block, (Item)new ItemBlock(block), name, tab);
    }

    public static Block registerBlock(@Nonnull Block block, @Nonnull Item itemBlock, @Nonnull String name) {
        return AtumRegistry.registerBlock(block, itemBlock, name, Atum.CREATIVE_TAB);
    }

    public static Block registerBlock(@Nonnull Block block, @Nonnull Item itemBlock, @Nonnull String name, @Nullable CreativeTabs tab) {
        block.setRegistryName(new ResourceLocation("atum", AtumUtils.toRegistryName(name)));
        block.func_149663_c("atum." + AtumUtils.toUnlocalizedName(name));
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        AtumRegistry.registerItem(itemBlock, AtumUtils.toRegistryName(name));
        if (tab != null) {
            block.func_149647_a(tab);
        } else if (Constants.IS_JEI_LOADED) {
            HIDE_LIST.add((Object)new ItemStack(block));
        }
        if (block instanceof IOreDictEntry) {
            IOreDictEntry entry = (IOreDictEntry)block;
            OreDictHelper.entries.add((Object)entry);
        }
        if (block instanceof IRenderMapper && FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            ClientProxy.ignoreRenderProperty(block);
        }
        return block;
    }

    public static EntityEntry registerMob(@Nonnull Class<? extends Entity> entityClass, int eggPrimary, int eggSecondary) {
        ResourceLocation location = new ResourceLocation("atum", CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, entityClass.getSimpleName()).replace("entity_", ""));
        EntityEntry entry = new EntityEntry(entityClass, location.toString());
        entry.setRegistryName(location);
        entry.setEgg(new EntityList.EntityEggInfo(location, eggPrimary, eggSecondary));
        MOBS.add((Object)entry);
        return entry;
    }

    public static EntityEntry registerArrow(@Nonnull Class<? extends Entity> entityClass) {
        return AtumRegistry.registerEntity(entityClass, 64, 20, false);
    }

    public static EntityEntry registerEntity(@Nonnull Class<? extends Entity> entityClass, int range, int updateFreq, boolean sendVelocityUpdates) {
        ResourceLocation location = new ResourceLocation("atum", CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, entityClass.getSimpleName()).replace("entity_", ""));
        EntityEntry entry = new EntityEntry(entityClass, location.toString());
        entry.setRegistryName(location);
        trackingRange.put(location, range);
        updateFrequency.put(location, updateFreq);
        sendsVelocityUpdates.put(location, sendVelocityUpdates);
        ENTITIES.add((Object)entry);
        return entry;
    }

    public static AtumBiome registerBiome(AtumBiome biome, String name) {
        biome.setRegistryName(new ResourceLocation("atum", name));
        BIOMES.add((Object)biome);
        return biome;
    }

    public static SoundEvent registerSound(String name) {
        ResourceLocation resourceLocation = new ResourceLocation("atum", name);
        SoundEvent sound = new SoundEvent(resourceLocation);
        sound.setRegistryName(resourceLocation);
        SOUNDS.add((Object)sound);
        return sound;
    }

    public static <T extends IForgeRegistryEntry<T>> T registerRecipe(String registryName, T entry, RegistryEvent.Register<T> event) {
        entry.setRegistryName(new ResourceLocation("atum", registryName));
        event.getRegistry().register(entry);
        return entry;
    }

    public static <T extends IForgeRegistryEntry<T>> IForgeRegistry<T> makeRegistry(String registryName, Class<T> type) {
        return new RegistryBuilder().setName(new ResourceLocation("atum", registryName)).setType(type).setMaxID(0x3FFFFFF).allowModification().create();
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        AtumItems.registerItems();
        AtumItems.setItemInfo();
        OreDictHelper.register();
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        AtumBlocks.registerBlocks();
        AtumBlocks.setBlockInfo();
        AtumBlocks.registerTileEntities();
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        AtumBiomes.registerBiomes();
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        new AtumEntities();
        int networkIdMob = 0;
        for (EntityEntry entry : MOBS) {
            Preconditions.checkNotNull((Object)entry.getRegistryName(), (Object)"registryName");
            event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(entry.getEntityClass()).id(entry.getRegistryName(), ++networkIdMob).name(AtumUtils.toUnlocalizedName(entry.getName())).tracker(80, 3, true).egg(entry.getEgg().field_75611_b, entry.getEgg().field_75612_c).build());
        }
        int networkIdEntity = MOBS.size() + 1;
        for (EntityEntry entry : ENTITIES) {
            Preconditions.checkNotNull((Object)entry.getRegistryName(), (Object)"registryName");
            event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(entry.getEntityClass()).id(entry.getRegistryName(), ++networkIdEntity).tracker(trackingRange.get(entry.getRegistryName()).intValue(), updateFrequency.get(entry.getRegistryName()).intValue(), sendsVelocityUpdates.get(entry.getRegistryName()).booleanValue()).name(AtumUtils.toUnlocalizedName(entry.getName())).build());
        }
        EntityRegistry.instance().lookupModSpawn(EntityCamelSpit.class, true).setCustomSpawning(null, true);
    }

    @SubscribeEvent
    public static void registerSound(RegistryEvent.Register<SoundEvent> event) {
        for (SoundEvent sound : SOUNDS) {
            event.getRegistry().register((IForgeRegistryEntry)sound);
        }
    }
}

